/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.directory.server.core.partition.impl.btree.Tuple;
import org.apache.directory.server.core.partition.impl.btree.TupleBrowser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoDupsEnumeration
implements NamingEnumeration<Tuple> {
    private final Tuple returned = new Tuple();
    private final Tuple prefetched = new Tuple();
    private final TupleBrowser browser;
    private final boolean doAscendingScan;
    private boolean hasNext = true;

    public NoDupsEnumeration(TupleBrowser browser, boolean doAscendingScan) throws NamingException {
        this.browser = browser;
        this.doAscendingScan = doAscendingScan;
        this.prefetch();
    }

    @Override
    public Tuple next() throws NamingException {
        this.returned.setKey(this.prefetched.getKey());
        this.returned.setValue(this.prefetched.getValue());
        this.prefetch();
        return this.returned;
    }

    @Override
    public Tuple nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public boolean hasMore() {
        return this.hasNext;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNext;
    }

    @Override
    public void close() {
        this.hasNext = false;
    }

    public boolean doAscendingScan() {
        return this.doAscendingScan;
    }

    private void prefetch() throws NamingException {
        boolean isSuccess = false;
        isSuccess = this.doAscendingScan ? this.browser.getNext(this.prefetched) : this.browser.getPrevious(this.prefetched);
        this.hasNext = isSuccess;
    }
}

