/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.userworkspace.operations;

import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;

@Operation(id="UserWorkspace.CreateDocumentFromBlob", category="Services", label="Create Document from file in User's workspace", description="Create Document(s) in the user's workspace from Blob(s) using the FileManagerService.")
public class UserWorkspaceCreateFromBlob {
    public static final String ID = "UserWorkspace.CreateDocumentFromBlob";
    @Context
    protected CoreSession session;
    @Context
    protected FileManager fileManager;
    @Context
    protected OperationContext context;
    @Context
    protected UserWorkspaceService userWorkspace;
    @Context
    protected AutomationService as;

    protected DocumentModel getCurrentDocument() throws Exception {
        String cdRef = (String)this.context.get((Object)"currentDocument");
        return (DocumentModel)this.as.getAdaptedValue(this.context, (Object)cdRef, DocumentModel.class);
    }

    @OperationMethod
    public DocumentModel run(Blob blob) throws Exception {
        DocumentModel userws = this.userWorkspace.getCurrentUserPersonalWorkspace(this.session, this.getCurrentDocument());
        DocumentModel doc = this.fileManager.createDocumentFromBlob(this.session, blob, userws.getPathAsString(), false, blob.getFilename());
        return doc;
    }

    @OperationMethod
    public DocumentModelList run(BlobList blobs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (Blob blob : blobs) {
            result.add((Object)this.run(blob));
        }
        return result;
    }
}

