/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.record.formula.eval.ExternalFunction;
import org.apache.poi.hssf.record.formula.eval.OperationEval;
import org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import org.apache.poi.hssf.record.formula.function.FunctionMetadataRegistry;
import org.apache.poi.hssf.record.formula.functions.AggregateFunction;
import org.apache.poi.hssf.record.formula.functions.And;
import org.apache.poi.hssf.record.formula.functions.CalendarFieldFunction;
import org.apache.poi.hssf.record.formula.functions.Choose;
import org.apache.poi.hssf.record.formula.functions.Column;
import org.apache.poi.hssf.record.formula.functions.Columns;
import org.apache.poi.hssf.record.formula.functions.Count;
import org.apache.poi.hssf.record.formula.functions.Counta;
import org.apache.poi.hssf.record.formula.functions.Countif;
import org.apache.poi.hssf.record.formula.functions.DateFunc;
import org.apache.poi.hssf.record.formula.functions.Errortype;
import org.apache.poi.hssf.record.formula.functions.Even;
import org.apache.poi.hssf.record.formula.functions.False;
import org.apache.poi.hssf.record.formula.functions.FinanceFunction;
import org.apache.poi.hssf.record.formula.functions.Find;
import org.apache.poi.hssf.record.formula.functions.FreeRefFunction;
import org.apache.poi.hssf.record.formula.functions.Function;
import org.apache.poi.hssf.record.formula.functions.Hlookup;
import org.apache.poi.hssf.record.formula.functions.Hyperlink;
import org.apache.poi.hssf.record.formula.functions.If;
import org.apache.poi.hssf.record.formula.functions.Index;
import org.apache.poi.hssf.record.formula.functions.Indirect;
import org.apache.poi.hssf.record.formula.functions.IsError;
import org.apache.poi.hssf.record.formula.functions.Isblank;
import org.apache.poi.hssf.record.formula.functions.Islogical;
import org.apache.poi.hssf.record.formula.functions.Isnontext;
import org.apache.poi.hssf.record.formula.functions.Isnumber;
import org.apache.poi.hssf.record.formula.functions.Isref;
import org.apache.poi.hssf.record.formula.functions.Istext;
import org.apache.poi.hssf.record.formula.functions.Lookup;
import org.apache.poi.hssf.record.formula.functions.Match;
import org.apache.poi.hssf.record.formula.functions.MinaMaxa;
import org.apache.poi.hssf.record.formula.functions.Mode;
import org.apache.poi.hssf.record.formula.functions.Na;
import org.apache.poi.hssf.record.formula.functions.Not;
import org.apache.poi.hssf.record.formula.functions.NotImplementedFunction;
import org.apache.poi.hssf.record.formula.functions.Now;
import org.apache.poi.hssf.record.formula.functions.NumericFunction;
import org.apache.poi.hssf.record.formula.functions.Odd;
import org.apache.poi.hssf.record.formula.functions.Offset;
import org.apache.poi.hssf.record.formula.functions.Or;
import org.apache.poi.hssf.record.formula.functions.Pi;
import org.apache.poi.hssf.record.formula.functions.Rand;
import org.apache.poi.hssf.record.formula.functions.Replace;
import org.apache.poi.hssf.record.formula.functions.Row;
import org.apache.poi.hssf.record.formula.functions.Rows;
import org.apache.poi.hssf.record.formula.functions.Substitute;
import org.apache.poi.hssf.record.formula.functions.Sumif;
import org.apache.poi.hssf.record.formula.functions.Sumproduct;
import org.apache.poi.hssf.record.formula.functions.Sumx2my2;
import org.apache.poi.hssf.record.formula.functions.Sumx2py2;
import org.apache.poi.hssf.record.formula.functions.Sumxmy2;
import org.apache.poi.hssf.record.formula.functions.T;
import org.apache.poi.hssf.record.formula.functions.TextFunction;
import org.apache.poi.hssf.record.formula.functions.Time;
import org.apache.poi.hssf.record.formula.functions.Today;
import org.apache.poi.hssf.record.formula.functions.True;
import org.apache.poi.hssf.record.formula.functions.Value;
import org.apache.poi.hssf.record.formula.functions.Vlookup;

public abstract class FunctionEval
implements OperationEval {
    private static final FunctionID ID = null;
    protected static final Function[] functions;
    private static Map<Integer, FreeRefFunction> freeRefFunctionsByIdMap;

    private static Integer createFRFKey(int functionIndex) {
        return new Integer(functionIndex);
    }

    public Function getFunction() {
        short fidx = this.getFunctionIndex();
        return functions[fidx];
    }

    public boolean isFreeRefFunction() {
        return freeRefFunctionsByIdMap.containsKey(FunctionEval.createFRFKey(this.getFunctionIndex()));
    }

    public FreeRefFunction getFreeRefFunction() {
        return freeRefFunctionsByIdMap.get(FunctionEval.createFRFKey(this.getFunctionIndex()));
    }

    public abstract short getFunctionIndex();

    private static Function[] produceFunctions() {
        Function[] retval = new Function[368];
        retval[0] = new Count();
        retval[1] = new If();
        retval[3] = new IsError();
        retval[4] = AggregateFunction.SUM;
        retval[5] = AggregateFunction.AVERAGE;
        retval[6] = AggregateFunction.MIN;
        retval[7] = AggregateFunction.MAX;
        retval[8] = new Row();
        retval[9] = new Column();
        retval[10] = new Na();
        retval[12] = AggregateFunction.STDEV;
        retval[13] = NumericFunction.DOLLAR;
        retval[15] = NumericFunction.SIN;
        retval[16] = NumericFunction.COS;
        retval[17] = NumericFunction.TAN;
        retval[18] = NumericFunction.ATAN;
        retval[19] = new Pi();
        retval[20] = NumericFunction.SQRT;
        retval[21] = NumericFunction.EXP;
        retval[22] = NumericFunction.LN;
        retval[23] = NumericFunction.LOG10;
        retval[24] = NumericFunction.ABS;
        retval[25] = NumericFunction.INT;
        retval[26] = NumericFunction.SIGN;
        retval[27] = NumericFunction.ROUND;
        retval[28] = new Lookup();
        retval[29] = new Index();
        retval[31] = TextFunction.MID;
        retval[32] = TextFunction.LEN;
        retval[33] = new Value();
        retval[34] = new True();
        retval[35] = new False();
        retval[36] = new And();
        retval[37] = new Or();
        retval[38] = new Not();
        retval[39] = NumericFunction.MOD;
        retval[56] = FinanceFunction.PV;
        retval[57] = FinanceFunction.FV;
        retval[58] = FinanceFunction.NPER;
        retval[59] = FinanceFunction.PMT;
        retval[63] = new Rand();
        retval[64] = new Match();
        retval[65] = DateFunc.instance;
        retval[66] = new Time();
        retval[67] = CalendarFieldFunction.DAY;
        retval[68] = CalendarFieldFunction.MONTH;
        retval[69] = CalendarFieldFunction.YEAR;
        retval[74] = new Now();
        retval[76] = new Rows();
        retval[77] = new Columns();
        retval[78] = new Offset();
        retval[97] = NumericFunction.ATAN2;
        retval[98] = NumericFunction.ASIN;
        retval[99] = NumericFunction.ACOS;
        retval[100] = new Choose();
        retval[101] = new Hlookup();
        retval[102] = new Vlookup();
        retval[105] = new Isref();
        retval[109] = NumericFunction.LOG;
        retval[112] = TextFunction.LOWER;
        retval[113] = TextFunction.UPPER;
        retval[115] = TextFunction.LEFT;
        retval[116] = TextFunction.RIGHT;
        retval[117] = TextFunction.EXACT;
        retval[118] = TextFunction.TRIM;
        retval[119] = new Replace();
        retval[120] = new Substitute();
        retval[124] = new Find();
        retval[127] = new Istext();
        retval[128] = new Isnumber();
        retval[129] = new Isblank();
        retval[130] = new T();
        retval[148] = null;
        retval[169] = new Counta();
        retval[183] = AggregateFunction.PRODUCT;
        retval[184] = NumericFunction.FACT;
        retval[190] = new Isnontext();
        retval[198] = new Islogical();
        retval[212] = NumericFunction.ROUNDUP;
        retval[213] = NumericFunction.ROUNDDOWN;
        retval[221] = new Today();
        retval[227] = AggregateFunction.MEDIAN;
        retval[228] = new Sumproduct();
        retval[229] = NumericFunction.SINH;
        retval[230] = NumericFunction.COSH;
        retval[231] = NumericFunction.TANH;
        retval[232] = NumericFunction.ASINH;
        retval[233] = NumericFunction.ACOSH;
        retval[234] = NumericFunction.ATANH;
        retval[255] = null;
        retval[261] = new Errortype();
        retval[269] = AggregateFunction.AVEDEV;
        retval[276] = NumericFunction.COMBIN;
        retval[279] = new Even();
        retval[285] = NumericFunction.FLOOR;
        retval[288] = NumericFunction.CEILING;
        retval[298] = new Odd();
        retval[303] = new Sumxmy2();
        retval[304] = new Sumx2my2();
        retval[305] = new Sumx2py2();
        retval[318] = AggregateFunction.DEVSQ;
        retval[321] = AggregateFunction.SUMSQ;
        retval[325] = AggregateFunction.LARGE;
        retval[326] = AggregateFunction.SMALL;
        retval[330] = new Mode();
        retval[336] = TextFunction.CONCATENATE;
        retval[337] = NumericFunction.POWER;
        retval[342] = NumericFunction.RADIANS;
        retval[343] = NumericFunction.DEGREES;
        retval[345] = new Sumif();
        retval[346] = new Countif();
        retval[359] = new Hyperlink();
        retval[362] = MinaMaxa.MAXA;
        retval[363] = MinaMaxa.MINA;
        for (int i = 0; i < retval.length; ++i) {
            FunctionMetadata fm;
            Function f = retval[i];
            if (f != null || (fm = FunctionMetadataRegistry.getFunctionByIndex(i)) == null) continue;
            retval[i] = new NotImplementedFunction(fm.getName());
        }
        return retval;
    }

    static {
        HashMap<Integer, FreeRefFunction> m = new HashMap<Integer, FreeRefFunction>();
        m.put(FunctionEval.createFRFKey(148), new Indirect());
        m.put(FunctionEval.createFRFKey(255), new ExternalFunction());
        freeRefFunctionsByIdMap = m;
        functions = FunctionEval.produceFunctions();
    }

    private static final class FunctionID {
        public static final int SUM = 4;
        public static final int OFFSET = 78;
        public static final int INDIRECT = 148;
        public static final int EXTERNAL_FUNC = 255;

        private FunctionID() {
        }
    }
}

