/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.OperationEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;

public final class RangeEval
implements OperationEval {
    public static final OperationEval instance = new RangeEval();

    private RangeEval() {
    }

    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        if (args.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            AreaEval reA = RangeEval.evaluateRef(args[0]);
            AreaEval reB = RangeEval.evaluateRef(args[1]);
            return RangeEval.resolveRange(reA, reB);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    private static AreaEval resolveRange(AreaEval aeA, AreaEval aeB) {
        int aeAfr = aeA.getFirstRow();
        int aeAfc = aeA.getFirstColumn();
        int top = Math.min(aeAfr, aeB.getFirstRow());
        int bottom = Math.max(aeA.getLastRow(), aeB.getLastRow());
        int left = Math.min(aeAfc, aeB.getFirstColumn());
        int right = Math.max(aeA.getLastColumn(), aeB.getLastColumn());
        return aeA.offset(top - aeAfr, bottom - aeAfr, left - aeAfc, right - aeAfc);
    }

    private static AreaEval evaluateRef(Eval arg) throws EvaluationException {
        if (arg instanceof AreaEval) {
            return (AreaEval)arg;
        }
        if (arg instanceof RefEval) {
            return ((RefEval)arg).offset(0, 0, 0, 0);
        }
        if (arg instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)arg);
        }
        throw new IllegalArgumentException("Unexpected ref arg class (" + arg.getClass().getName() + ")");
    }

    public int getNumberOfOperands() {
        return 2;
    }
}

