/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.poi.hssf.usermodel.FontDetails;

class StaticFontMetrics {
    private static Properties fontMetricsProps;
    private static Map fontDetailsMap;

    StaticFontMetrics() {
    }

    public static FontDetails getFontDetails(Font font) {
        if (fontMetricsProps == null) {
            InputStream metricsIn = null;
            try {
                fontMetricsProps = new Properties();
                String propFileName = null;
                try {
                    propFileName = System.getProperty("font.metrics.filename");
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                if (propFileName != null) {
                    File file = new File(propFileName);
                    if (!file.exists()) {
                        throw new FileNotFoundException("font_metrics.properties not found at path " + file.getAbsolutePath());
                    }
                    metricsIn = new FileInputStream(file);
                } else {
                    metricsIn = FontDetails.class.getResourceAsStream("/font_metrics.properties");
                    if (metricsIn == null) {
                        throw new FileNotFoundException("font_metrics.properties not found in classpath");
                    }
                }
                fontMetricsProps.load(metricsIn);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load font metrics: " + e.getMessage());
            }
            finally {
                if (metricsIn != null) {
                    try {
                        metricsIn.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        String fontName = font.getName();
        String fontStyle = "";
        if (font.isPlain()) {
            fontStyle = fontStyle + "plain";
        }
        if (font.isBold()) {
            fontStyle = fontStyle + "bold";
        }
        if (font.isItalic()) {
            fontStyle = fontStyle + "italic";
        }
        if (fontMetricsProps.get(FontDetails.buildFontHeightProperty(fontName)) == null && fontMetricsProps.get(FontDetails.buildFontHeightProperty(fontName + "." + fontStyle)) != null) {
            fontName = fontName + "." + fontStyle;
        }
        if (fontDetailsMap.get(fontName) == null) {
            FontDetails fontDetails = FontDetails.create(fontName, fontMetricsProps);
            fontDetailsMap.put(fontName, fontDetails);
            return fontDetails;
        }
        return (FontDetails)fontDetailsMap.get(fontName);
    }

    static {
        fontDetailsMap = new HashMap();
    }
}

