/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.record.formula.SheetNameFormatter;
import org.apache.poi.ss.SpreadsheetVersion;

public class CellReference {
    private static final char ABSOLUTE_REFERENCE_MARKER = '$';
    private static final char SHEET_NAME_DELIMITER = '!';
    private static final char SPECIAL_NAME_DELIMITER = '\'';
    private static final Pattern CELL_REF_PATTERN = Pattern.compile("\\$?([A-Za-z]+)\\$?([0-9]+)");
    private static final Pattern COLUMN_REF_PATTERN = Pattern.compile("\\$?([A-Za-z]+)");
    private static final Pattern NAMED_RANGE_NAME_PATTERN = Pattern.compile("[_A-Za-z][_.A-Za-z0-9]*");
    private final int _rowIndex;
    private final int _colIndex;
    private final String _sheetName;
    private final boolean _isRowAbs;
    private final boolean _isColAbs;

    public CellReference(String cellRef) {
        String[] parts = CellReference.separateRefParts(cellRef);
        this._sheetName = parts[0];
        String colRef = parts[1];
        if (colRef.length() < 1) {
            throw new IllegalArgumentException("Invalid Formula cell reference: '" + cellRef + "'");
        }
        boolean bl = this._isColAbs = colRef.charAt(0) == '$';
        if (this._isColAbs) {
            colRef = colRef.substring(1);
        }
        this._colIndex = CellReference.convertColStringToIndex(colRef);
        String rowRef = parts[2];
        if (rowRef.length() < 1) {
            throw new IllegalArgumentException("Invalid Formula cell reference: '" + cellRef + "'");
        }
        boolean bl2 = this._isRowAbs = rowRef.charAt(0) == '$';
        if (this._isRowAbs) {
            rowRef = rowRef.substring(1);
        }
        this._rowIndex = Integer.parseInt(rowRef) - 1;
    }

    public CellReference(int pRow, int pCol) {
        this(pRow, pCol, false, false);
    }

    public CellReference(int pRow, short pCol) {
        this(pRow, pCol & 0xFFFF, false, false);
    }

    public CellReference(int pRow, int pCol, boolean pAbsRow, boolean pAbsCol) {
        this(null, pRow, pCol, pAbsRow, pAbsCol);
    }

    public CellReference(String pSheetName, int pRow, int pCol, boolean pAbsRow, boolean pAbsCol) {
        if (pRow < -1) {
            throw new IllegalArgumentException("row index may not be negative");
        }
        if (pCol < -1) {
            throw new IllegalArgumentException("column index may not be negative");
        }
        this._sheetName = pSheetName;
        this._rowIndex = pRow;
        this._colIndex = pCol;
        this._isRowAbs = pAbsRow;
        this._isColAbs = pAbsCol;
    }

    public int getRow() {
        return this._rowIndex;
    }

    public short getCol() {
        return (short)this._colIndex;
    }

    public boolean isRowAbsolute() {
        return this._isRowAbs;
    }

    public boolean isColAbsolute() {
        return this._isColAbs;
    }

    public String getSheetName() {
        return this._sheetName;
    }

    public static boolean isPartAbsolute(String part) {
        return part.charAt(0) == '$';
    }

    public static int convertColStringToIndex(String ref) {
        int pos = 0;
        int retval = 0;
        for (int k = ref.length() - 1; k >= 0; --k) {
            char thechar = ref.charAt(k);
            if (thechar == '$') {
                if (k == 0) break;
                throw new IllegalArgumentException("Bad col ref format '" + ref + "'");
            }
            int shift = (int)Math.pow(26.0, pos);
            retval += (Character.getNumericValue(thechar) - 9) * shift;
            ++pos;
        }
        return retval - 1;
    }

    public static int classifyCellReference(String str, SpreadsheetVersion ssVersion) {
        String digitsGroup;
        int len = str.length();
        if (len < 1) {
            throw new IllegalArgumentException("Empty string not allowed");
        }
        char firstChar = str.charAt(0);
        switch (firstChar) {
            case '$': 
            case '.': 
            case '_': {
                break;
            }
            default: {
                if (Character.isLetter(firstChar)) break;
                throw new IllegalArgumentException("Invalid first char (" + firstChar + ") of cell reference or named range.  Letter expected");
            }
        }
        if (!Character.isDigit(str.charAt(len - 1))) {
            return CellReference.validateNamedRangeName(str, ssVersion);
        }
        Matcher cellRefPatternMatcher = CELL_REF_PATTERN.matcher(str);
        if (!cellRefPatternMatcher.matches()) {
            return CellReference.validateNamedRangeName(str, ssVersion);
        }
        String lettersGroup = cellRefPatternMatcher.group(1);
        if (CellReference.cellReferenceIsWithinRange(lettersGroup, digitsGroup = cellRefPatternMatcher.group(2), ssVersion)) {
            return 1;
        }
        if (str.indexOf(36) >= 0) {
            return -1;
        }
        return 2;
    }

    private static int validateNamedRangeName(String str, SpreadsheetVersion ssVersion) {
        String colStr;
        Matcher colMatcher = COLUMN_REF_PATTERN.matcher(str);
        if (colMatcher.matches() && CellReference.isColumnWithnRange(colStr = colMatcher.group(1), ssVersion)) {
            return 3;
        }
        if (!NAMED_RANGE_NAME_PATTERN.matcher(str).matches()) {
            return -1;
        }
        return 2;
    }

    public static boolean cellReferenceIsWithinRange(String colStr, String rowStr, SpreadsheetVersion ssVersion) {
        if (!CellReference.isColumnWithnRange(colStr, ssVersion)) {
            return false;
        }
        int rowNum = Integer.parseInt(rowStr);
        if (rowNum < 0) {
            throw new IllegalStateException("Invalid rowStr '" + rowStr + "'.");
        }
        if (rowNum == 0) {
            return false;
        }
        return rowNum <= ssVersion.getMaxRows();
    }

    public static boolean isColumnWithnRange(String colStr, SpreadsheetVersion ssVersion) {
        String lastCol = ssVersion.getLastColumnName();
        int lastColLength = lastCol.length();
        int numberOfLetters = colStr.length();
        if (numberOfLetters > lastColLength) {
            return false;
        }
        return numberOfLetters != lastColLength || colStr.toUpperCase().compareTo(lastCol) <= 0;
    }

    private static String[] separateRefParts(String reference) {
        char ch;
        int plingPos = reference.lastIndexOf(33);
        String sheetName = CellReference.parseSheetName(reference, plingPos);
        int start = plingPos + 1;
        int length = reference.length();
        int loc = start;
        if (reference.charAt(loc) == '$') {
            ++loc;
        }
        while (loc < length && !Character.isDigit(ch = reference.charAt(loc)) && ch != '$') {
            ++loc;
        }
        return new String[]{sheetName, reference.substring(start, loc), reference.substring(loc)};
    }

    private static String parseSheetName(String reference, int indexOfSheetNameDelimiter) {
        boolean isQuoted;
        if (indexOfSheetNameDelimiter < 0) {
            return null;
        }
        boolean bl = isQuoted = reference.charAt(0) == '\'';
        if (!isQuoted) {
            return reference.substring(0, indexOfSheetNameDelimiter);
        }
        int lastQuotePos = indexOfSheetNameDelimiter - 1;
        if (reference.charAt(lastQuotePos) != '\'') {
            throw new RuntimeException("Mismatched quotes: (" + reference + ")");
        }
        StringBuffer sb = new StringBuffer(indexOfSheetNameDelimiter);
        for (int i = 1; i < lastQuotePos; ++i) {
            char ch = reference.charAt(i);
            if (ch != '\'') {
                sb.append(ch);
                continue;
            }
            if (i < lastQuotePos && reference.charAt(i + 1) == '\'') {
                ++i;
                sb.append(ch);
                continue;
            }
            throw new RuntimeException("Bad sheet name quote escaping: (" + reference + ")");
        }
        return sb.toString();
    }

    public static String convertNumToColString(int col) {
        int excelColNum = col + 1;
        String colRef = "";
        int colRemain = excelColNum;
        while (colRemain > 0) {
            int thisPart = colRemain % 26;
            if (thisPart == 0) {
                thisPart = 26;
            }
            colRemain = (colRemain - thisPart) / 26;
            char colChar = (char)(thisPart + 64);
            colRef = colChar + colRef;
        }
        return colRef;
    }

    public String formatAsString() {
        StringBuffer sb = new StringBuffer(32);
        if (this._sheetName != null) {
            SheetNameFormatter.appendFormat(sb, this._sheetName);
            sb.append('!');
        }
        this.appendCellReference(sb);
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this.formatAsString());
        sb.append("]");
        return sb.toString();
    }

    public String[] getCellRefParts() {
        return new String[]{this._sheetName, Integer.toString(this._rowIndex + 1), CellReference.convertNumToColString(this._colIndex)};
    }

    void appendCellReference(StringBuffer sb) {
        if (this._isColAbs) {
            sb.append('$');
        }
        sb.append(CellReference.convertNumToColString(this._colIndex));
        if (this._isRowAbs) {
            sb.append('$');
        }
        sb.append(this._rowIndex + 1);
    }

    public static final class NameType {
        public static final int CELL = 1;
        public static final int NAMED_RANGE = 2;
        public static final int COLUMN = 3;
        public static final int BAD_CELL_OR_NAMED_RANGE = -1;
    }
}

