/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.bootstrap;

import java.io.Serializable;
import java.util.Comparator;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.util.StringTools;

public class NameOrNumericIdComparator
implements Comparator,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient OidRegistry registry;

    public NameOrNumericIdComparator(OidRegistry registry) {
        this.registry = registry;
    }

    public NameOrNumericIdComparator() {
    }

    public int compare(Object o1, Object o2) {
        String s1 = this.getNumericIdString(o1);
        String s2 = this.getNumericIdString(o2);
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public void setRegistries(Registries registries) {
        this.registry = registries.getOidRegistry();
    }

    String getNumericIdString(Object obj) {
        if (obj == null) {
            return null;
        }
        String strValue = obj instanceof String ? (String)obj : (obj instanceof byte[] ? StringTools.utf8ToString((byte[])((byte[])obj)) : obj.toString());
        if (strValue.length() == 0) {
            return "";
        }
        if (this.registry.hasOid(strValue)) {
            try {
                return this.registry.getOid(strValue);
            }
            catch (NamingException e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to lookup OID for " + strValue, e);
            }
        }
        return strValue;
    }
}

