/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.querymodel;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModelService;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.FieldDescriptor;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.QueryModelDescriptor;
import org.nuxeo.ecm.core.search.api.client.search.results.ResultItem;
import org.nuxeo.ecm.core.search.api.client.search.results.document.SearchPageProvider;
import org.nuxeo.ecm.core.search.api.client.search.results.impl.DocumentModelResultItem;
import org.nuxeo.ecm.core.search.api.client.search.results.impl.ResultSetImpl;
import org.nuxeo.runtime.api.Framework;

@Deprecated
public class QueryModel
implements Serializable {
    private static final long serialVersionUID = 762348097532723566L;
    private static final Log log = LogFactory.getLog(QueryModel.class);
    protected transient QueryModelDescriptor descriptor;
    protected String descriptorName;
    protected int max;
    protected final DocumentModel documentModel;
    protected final DocumentModel originalDocumentModel;
    protected boolean isPersisted = false;
    protected transient QueryModelService queryModelService;
    protected Boolean detachResultsFlag;

    public QueryModel(QueryModelDescriptor descriptor, DocumentModel documentModel) {
        this.descriptor = descriptor;
        if (descriptor != null) {
            this.descriptorName = descriptor.getName();
            this.max = descriptor.getMax() == null ? 0 : descriptor.getMax();
        }
        this.documentModel = documentModel;
        if (documentModel == null) {
            this.originalDocumentModel = null;
        } else {
            try {
                documentModel.detach(true);
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            this.originalDocumentModel = new DocumentModelImpl(documentModel.getType());
            try {
                this.originalDocumentModel.copyContent(documentModel);
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
    }

    public QueryModel(QueryModelDescriptor descriptor) {
        this(descriptor, null);
    }

    public boolean detachResults() {
        if (this.detachResultsFlag == null) {
            this.detachResultsFlag = Boolean.valueOf(Framework.getProperty((String)"org.nuxeo.ecm.core.search.alwaysDetachResults", (String)"false"));
        }
        return this.detachResultsFlag;
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }

    public void setPersisted(boolean isPersisted) {
        this.isPersisted = isPersisted;
    }

    public DocumentModel getDocumentModel() {
        return this.documentModel;
    }

    public DocumentModelList getDocuments(CoreSession session) throws ClientException {
        return this.getDocuments(session, null);
    }

    public DocumentModelList getDocuments(CoreSession session, Object[] params) throws ClientException {
        return this.getResultsProvider(session, params).getCurrentPage();
    }

    private void checkDescriptor() {
        if (this.descriptor == null) {
            if (this.queryModelService == null) {
                this.queryModelService = (QueryModelService)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.core.search.api.client.querymodel.QueryModelService"));
            }
            this.descriptor = this.queryModelService.getQueryModelDescriptor(this.descriptorName);
        }
    }

    public PagedDocumentsProvider getResultsProvider(CoreSession session, Object[] params) throws ClientException {
        return this.getResultsProvider(session, params, null);
    }

    public PagedDocumentsProvider getResultsProvider(CoreSession session, Object[] params, SortInfo sortInfo) throws ClientException {
        this.checkDescriptor();
        if (sortInfo == null) {
            sortInfo = this.descriptor.getDefaultSortInfo(this.documentModel);
        }
        String query = this.descriptor.isStateful() ? this.descriptor.getQuery(this.documentModel, sortInfo) : this.descriptor.getQuery(params, sortInfo);
        if (log.isDebugEnabled()) {
            log.debug((Object)("execute query: " + query.replace('\n', ' ')));
        }
        DocumentModelList documentModelList = session.query(query, null, (long)this.max, 0L, true);
        int size = documentModelList.size();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>(size);
        for (DocumentModel doc : documentModelList) {
            if (doc == null) {
                log.error((Object)("Got null document from query: " + query));
                continue;
            }
            if (this.detachResults()) {
                try {
                    doc.detach(true);
                }
                catch (DocumentSecurityException e) {
                    continue;
                }
            }
            resultItems.add(new DocumentModelResultItem(doc));
        }
        ResultSetImpl resultSet = new ResultSetImpl(query, session, 0, this.max, resultItems, (int)documentModelList.totalSize(), size);
        return new SearchPageProvider(resultSet, this.isSortable(), sortInfo, query);
    }

    public QueryModelDescriptor getDescriptor() {
        this.checkDescriptor();
        return this.descriptor;
    }

    public Object getProperty(String schemaName, String name) {
        try {
            return this.documentModel.getProperty(schemaName, name);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void setProperty(String schemaName, String name, Object value) {
        try {
            this.documentModel.setProperty(schemaName, name, value);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public Object getPropertyValue(String xpath) {
        try {
            return this.documentModel.getPropertyValue(xpath);
        }
        catch (PropertyException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void setPropertyValue(String xpath, Serializable value) {
        try {
            this.documentModel.setPropertyValue(xpath, value);
        }
        catch (PropertyException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void setSortColumn(String value) {
        FieldDescriptor fd = this.getDescriptor().getSortColumnField();
        if (fd.getXpath() != null) {
            this.setPropertyValue(fd.getXpath(), (Serializable)((Object)value));
        } else {
            this.setProperty(fd.getSchema(), fd.getName(), value);
        }
    }

    public String getSortColumn() {
        FieldDescriptor fd = this.getDescriptor().getSortColumnField();
        if (fd.getXpath() != null) {
            return (String)this.getPropertyValue(fd.getXpath());
        }
        return (String)this.getProperty(fd.getSchema(), fd.getName());
    }

    public boolean getSortAscending() {
        FieldDescriptor fd = this.getDescriptor().getSortAscendingField();
        Boolean result = fd.getXpath() != null ? (Boolean)this.getPropertyValue(fd.getXpath()) : (Boolean)this.getProperty(fd.getSchema(), fd.getName());
        return Boolean.TRUE.equals(result);
    }

    public void setSortAscending(boolean sortAscending) {
        FieldDescriptor fd = this.getDescriptor().getSortAscendingField();
        if (fd.getXpath() != null) {
            this.setPropertyValue(fd.getXpath(), Boolean.valueOf(sortAscending));
        } else {
            this.setProperty(fd.getSchema(), fd.getName(), sortAscending);
        }
    }

    public boolean isSortable() {
        return this.getDescriptor().isSortable();
    }

    public void reset() {
        try {
            this.documentModel.copyContent(this.originalDocumentModel);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }
}

