/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.querymodel.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.FacetDescriptor;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.FieldDescriptor;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.WhereClauseDescriptor;
import org.nuxeo.runtime.model.RuntimeContext;

@XObject(value="queryModel")
public class QueryModelDescriptor {
    private static final Log log = LogFactory.getLog(QueryModelDescriptor.class);
    @XNode(value="@name")
    protected String name;
    @XNode(value="@docType")
    protected String docType;
    protected String pattern;
    @XNode(value="whereClause")
    protected WhereClauseDescriptor whereClause;
    @XNode(value="sortColumn/field")
    protected FieldDescriptor sortColumnField;
    @XNode(value="sortAscending/field")
    protected FieldDescriptor sortAscendingField;
    @XNode(value="batchSize/field")
    protected FieldDescriptor batchSize;
    @XNode(value="batchLength/field")
    protected FieldDescriptor batchLength;
    @XNodeList(value="facet-filter/facet", type=ArrayList.class, componentType=FacetDescriptor.class)
    public List<FacetDescriptor> filterFacets;
    @XNode(value="sortable@defaultSortColumn")
    protected String defaultSortColumn;
    @XNode(value="sortable@defaultSortAscending")
    protected Boolean defaultSortAscending = Boolean.TRUE;
    @Deprecated
    @XNode(value="sortable@value")
    Boolean sortable = Boolean.FALSE;
    @XNode(value="max")
    protected Integer max;

    @XNode(value="pattern")
    public void setPattern(String pattern) {
        if (pattern != null) {
            this.pattern = pattern.replaceAll("\r?\n\\s*", " ");
        }
    }

    public FieldDescriptor getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(FieldDescriptor batchSize) {
        this.batchSize = batchSize;
    }

    public FieldDescriptor getBatchLength() {
        return this.batchLength;
    }

    public void setBatchLength(FieldDescriptor batchLength) {
        this.batchLength = batchLength;
    }

    public String getDefaultSortColumn() {
        return this.defaultSortColumn;
    }

    public void setDefaultSortColumn(String defaultSortColumn) {
        this.defaultSortColumn = defaultSortColumn;
    }

    public Boolean getDefaultSortAscending() {
        return this.defaultSortAscending;
    }

    public void setDefaultSortAscending(Boolean defaultSortAscending) {
        this.defaultSortAscending = defaultSortAscending;
    }

    public Boolean getSortable() {
        return this.sortable;
    }

    public void setSortable(Boolean sortable) {
        this.sortable = sortable;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSortColumnField(FieldDescriptor sortColumnField) {
        this.sortColumnField = sortColumnField;
    }

    public void setSortAscendingField(FieldDescriptor sortAscendingField) {
        this.sortAscendingField = sortAscendingField;
    }

    public QueryModelDescriptor() {
    }

    public QueryModelDescriptor(String name, String docType, String pattern, List<FacetDescriptor> filterFacets, WhereClauseDescriptor whereClause) {
        this.name = name;
        this.docType = docType;
        this.pattern = pattern;
        this.filterFacets = filterFacets;
        this.whereClause = whereClause;
    }

    public QueryModelDescriptor(String name, String docType, Integer max, WhereClauseDescriptor whereClause, FieldDescriptor sortColumnField, FieldDescriptor sortAscendingField) {
        this.name = name;
        this.docType = docType;
        this.max = max;
        this.whereClause = whereClause;
        this.sortColumnField = sortColumnField;
        this.sortAscendingField = sortAscendingField;
    }

    public boolean isStateless() {
        return this.pattern != null;
    }

    public boolean isStateful() {
        return this.docType != null;
    }

    public String getDocType() {
        return this.docType;
    }

    public String getQuery(DocumentModel model) throws ClientException {
        return this.getQuery(model, null);
    }

    public SortInfo getDefaultSortInfo(DocumentModel model) {
        if (this.isStateful()) {
            if (this.sortColumnField == null || this.sortAscendingField == null) {
                return null;
            }
            String sortColumn = this.sortColumnField.getPlainStringValue(model);
            Boolean sortAscendingObj = this.sortAscendingField.getBooleanValue(model);
            boolean sortAscending = Boolean.TRUE.equals(sortAscendingObj);
            if (sortColumn == null) {
                return null;
            }
            return new SortInfo(sortColumn, sortAscending);
        }
        if (this.defaultSortColumn == null) {
            return null;
        }
        return new SortInfo(this.defaultSortColumn, this.defaultSortAscending.booleanValue());
    }

    public String getQuery(DocumentModel model, SortInfo sortInfo) throws ClientException {
        if (!this.isStateful()) {
            throw new ClientException(this.name + " is not stateful");
        }
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT * FROM Document");
        if (this.whereClause != null) {
            queryBuilder.append(this.whereClause.getQueryElement(model));
        }
        if (sortInfo != null) {
            String sortColumn = sortInfo.getSortColumn();
            boolean sortAscending = sortInfo.getSortAscending();
            queryBuilder.append(" ORDER BY ");
            queryBuilder.append(sortColumn);
            if (!sortAscending) {
                queryBuilder.append(" DESC");
            }
        }
        String res = queryBuilder.toString();
        log.debug((Object)res);
        return res;
    }

    public String getQuery(Object[] params) throws ClientException {
        return this.getQuery(params, null);
    }

    public static String prepareStringLiteral(String s) {
        return "'" + s.replaceAll("'", "\\\\'") + "'";
    }

    private static void appendQuotedStringList(StringBuilder queryBuilder, List<?> listParam) {
        queryBuilder.append('(');
        ArrayList<String> quotedParam = new ArrayList<String>(listParam.size());
        for (Object param : listParam) {
            quotedParam.add(QueryModelDescriptor.prepareStringLiteral(param.toString()));
        }
        queryBuilder.append(StringUtils.join(quotedParam, (String)", "));
        queryBuilder.append(')');
    }

    public String getQuery(Object[] params, SortInfo sortInfo) throws ClientException {
        StringBuilder queryBuilder;
        if (!this.isStateless()) {
            throw new ClientException(this.name + " is not stateless");
        }
        if (params == null) {
            queryBuilder = new StringBuilder(this.pattern + ' ');
        } else {
            String[] queryStrList = (this.pattern + ' ').split("\\?");
            queryBuilder = new StringBuilder(queryStrList[0]);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] instanceof String[]) {
                    QueryModelDescriptor.appendQuotedStringList(queryBuilder, Arrays.asList((String[])params[i]));
                } else if (params[i] instanceof List) {
                    QueryModelDescriptor.appendQuotedStringList(queryBuilder, (List)params[i]);
                } else if (params[i] instanceof Boolean) {
                    boolean b = (Boolean)params[i];
                    queryBuilder.append(b ? 1 : 0);
                } else if (params[i] instanceof Number) {
                    queryBuilder.append(params[i]);
                } else if (params[i] instanceof Literal) {
                    queryBuilder.append(params[i].toString());
                } else {
                    String queryParam = params[i].toString();
                    queryBuilder.append(QueryModelDescriptor.prepareStringLiteral(queryParam));
                }
                queryBuilder.append(queryStrList[i + 1]);
            }
        }
        if (sortInfo != null) {
            String sortColumn = sortInfo.getSortColumn();
            boolean sortAscending = sortInfo.getSortAscending();
            queryBuilder.append("ORDER BY ").append(sortColumn).append(' ').append(sortAscending ? "" : "DESC");
        }
        return queryBuilder.toString().trim();
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public String getName() {
        return this.name;
    }

    public Filter getFilter() {
        if (this.filterFacets == null || this.filterFacets.isEmpty()) {
            return null;
        }
        ArrayList<String> requiredFacets = new ArrayList<String>();
        ArrayList<String> excludedFacets = new ArrayList<String>();
        for (FacetDescriptor descriptor : this.filterFacets) {
            if (descriptor.isRequired()) {
                requiredFacets.add(descriptor.getName());
                continue;
            }
            excludedFacets.add(descriptor.getName());
        }
        return new FacetFilter(requiredFacets, excludedFacets);
    }

    public WhereClauseDescriptor getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(WhereClauseDescriptor whereClause) {
        this.whereClause = whereClause;
    }

    public FieldDescriptor getSortColumnField() {
        return this.sortColumnField;
    }

    public FieldDescriptor getSortAscendingField() {
        return this.sortAscendingField;
    }

    public boolean isSortable() {
        if (this.isStateful()) {
            return this.sortColumnField != null && this.sortAscendingField != null;
        }
        return true;
    }

    public void initEscaper(RuntimeContext context) {
        this.whereClause.initEscaper(context);
    }
}

