/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.service.ConvertOption;

public class MimeTypeTranslationHelper {
    protected static final Map<String, List<ConvertOption>> srcMappings = new HashMap<String, List<ConvertOption>>();
    protected static final Map<String, List<ConvertOption>> dstMappings = new HashMap<String, List<ConvertOption>>();

    private MimeTypeTranslationHelper() {
    }

    public static void addConverter(ConverterDescriptor desc) {
        List<String> sMts = desc.getSourceMimeTypes();
        String dMt = desc.getDestinationMimeType();
        List<ConvertOption> dco = dstMappings.get(dMt);
        if (dco == null) {
            dco = new ArrayList<ConvertOption>();
        }
        for (String sMT : sMts) {
            List<ConvertOption> sco = srcMappings.get(sMT);
            if (sco == null) {
                sco = new ArrayList<ConvertOption>();
            }
            sco.add(new ConvertOption(desc.getConverterName(), dMt));
            srcMappings.put(sMT, sco);
            dco.add(new ConvertOption(desc.getConverterName(), sMT));
        }
        dstMappings.put(dMt, dco);
    }

    public static String getConverterName(String sourceMimeType, String destMimeType) {
        List<ConvertOption> sco = srcMappings.get(sourceMimeType);
        if (sco == null && (sco = srcMappings.get("*")) == null) {
            return null;
        }
        for (ConvertOption co : sco) {
            if (!co.mimeType.equals(destMimeType)) continue;
            return co.getConverterName();
        }
        return null;
    }

    public static List<String> getConverterNames(String sourceMimeType, String destMimeType) {
        List<ConvertOption> sco = srcMappings.get(sourceMimeType);
        ArrayList<String> converterNames = new ArrayList<String>();
        if (sco == null && (sco = srcMappings.get("*")) == null) {
            return converterNames;
        }
        for (ConvertOption co : sco) {
            if (!co.mimeType.equals(destMimeType)) continue;
            converterNames.add(co.getConverterName());
        }
        return converterNames;
    }

    public static List<String> getDestinationMimeTypes(String sourceMimeType) {
        ArrayList<String> dst = new ArrayList<String>();
        List<ConvertOption> sco = srcMappings.get(sourceMimeType);
        if (sco != null) {
            for (ConvertOption co : sco) {
                dst.add(co.getMimeType());
            }
        }
        return dst;
    }

    public static List<String> getSourceMimeTypes(String destinationMimeType) {
        ArrayList<String> src = new ArrayList<String>();
        List<ConvertOption> dco = dstMappings.get(destinationMimeType);
        if (dco != null) {
            for (ConvertOption co : dco) {
                src.add(co.getMimeType());
            }
        }
        return src;
    }
}

