/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.task.update.Entry;
import org.nuxeo.connect.update.task.update.Version;
import org.nuxeo.connect.update.xml.XmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RegistrySerializer {
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Map<String, Entry> registry, File file) throws IOException {
        FileOutputStream in = new FileOutputStream(file);
        try {
            RegistrySerializer.store(registry, in);
        }
        finally {
            in.close();
        }
    }

    public static void store(Map<String, Entry> registry, OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        RegistrySerializer.store(registry, writer);
        ((Writer)writer).flush();
    }

    public static void store(Map<String, Entry> registry, Writer out) throws IOException {
        XmlWriter writer = new XmlWriter("  ");
        RegistrySerializer.write(registry, writer);
        out.write(writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Entry> load(File file) throws PackageException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            Map<String, Entry> map = RegistrySerializer.load(in);
            return map;
        }
        finally {
            in.close();
        }
    }

    public static Map<String, Entry> load(InputStream in) throws PackageException {
        HashMap<String, Entry> registry = new HashMap<String, Entry>();
        try {
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            RegistrySerializer.read(document.getDocumentElement(), registry);
            return registry;
        }
        catch (PackageException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PackageException("Failed to load file update registry", e);
        }
    }

    public static void read(Element element, Map<String, Entry> registry) throws PackageException {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !"entry".equals(node.getNodeName())) continue;
            Entry entry = RegistrySerializer.readEntryElement((Element)node);
            registry.put(entry.getKey(), entry);
        }
    }

    public static Entry readEntryElement(Element element) throws PackageException {
        Entry entry = new Entry(RegistrySerializer.readKeyAttr(element));
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Version v;
            if (node.getNodeType() != 1) continue;
            String name = node.getNodeName();
            if ("version".equals(name)) {
                v = RegistrySerializer.readVersionElement((Element)node);
                entry.addVersion(v);
                continue;
            }
            if (!"base-version".equals(name)) continue;
            v = RegistrySerializer.readVersionElement((Element)node);
            entry.setBaseVersion(v);
        }
        return entry;
    }

    public static String readKeyAttr(Element element) throws PackageException {
        String key = element.getAttribute("key");
        if (key.length() == 0) {
            throw new PackageException("Invalid entry. No 'key' attribute found!");
        }
        return key;
    }

    public static String readNameAttr(Element element) throws PackageException {
        String version = element.getAttribute("name");
        if (version.length() == 0) {
            throw new PackageException("Invalid version entry. No 'name' attribute found!");
        }
        return version;
    }

    public static String readPathAttr(Element element) throws PackageException {
        String path = element.getAttribute("path");
        if (path.length() == 0) {
            throw new PackageException("Invalid version entry. No 'path' attribute found!");
        }
        return path;
    }

    public static Version readVersionElement(Element element) throws PackageException {
        Version v = new Version(RegistrySerializer.readNameAttr(element));
        v.setPath(RegistrySerializer.readPathAttr(element));
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !"package".equals(node.getNodeName())) continue;
            v.addPackage(((Element)node).getTextContent().trim());
        }
        return v;
    }

    public static void write(Map<String, Entry> registry, XmlWriter writer) {
        writer.writeXmlDecl();
        writer.start("registry");
        writer.startContent();
        for (Entry entry : registry.values()) {
            RegistrySerializer.writeEntry(entry, writer);
        }
        writer.end("registry");
    }

    public static void writeEntry(Entry entry, XmlWriter writer) {
        writer.start("entry");
        writer.attr("key", entry.getKey());
        writer.startContent();
        if (entry.hasBaseVersion()) {
            RegistrySerializer.writeBaseVersion(entry.getBaseVersion(), writer);
        }
        for (Version v : entry) {
            RegistrySerializer.writeVersion(v, writer);
        }
        writer.end("entry");
    }

    public static void writeBaseVersion(Version version, XmlWriter writer) {
        writer.start("base-version");
        writer.attr("name", version.getVersion());
        writer.attr("path", version.getPath());
        writer.end();
    }

    public static void writeVersion(Version version, XmlWriter writer) {
        writer.start("version");
        writer.attr("name", version.getVersion());
        writer.attr("path", version.getPath());
        writer.startContent();
        for (String pkg : version.getPackages()) {
            writer.element("package", pkg);
        }
        writer.end("version");
    }
}

