/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.update;

import java.io.File;
import org.nuxeo.connect.update.task.update.JarUtils;

public class UpdateOptions {
    protected String pkgId;
    protected File file;
    protected String nameWithoutVersion;
    protected String version;
    protected File targetFile;
    protected File targetDir;
    protected boolean allowDowngrade;
    protected boolean upgradeOnly;
    protected boolean deleteOnExit = false;

    public static UpdateOptions newInstance(String pkgId, File file, File targetDir) {
        String name = file.getName();
        JarUtils.Match<String> match = JarUtils.findJarVersion(name);
        if (match == null && pkgId != null && pkgId.endsWith("-0.0.0-SNAPSHOT")) {
            match = new JarUtils.Match();
            match.object = pkgId.substring(0, pkgId.length() - "-0.0.0-SNAPSHOT".length());
            match.version = "0.0.0-SNAPSHOT";
        }
        if (match == null) {
            return null;
        }
        UpdateOptions up = new UpdateOptions();
        up.pkgId = pkgId;
        up.file = file;
        up.nameWithoutVersion = (String)match.object;
        up.version = match.version;
        up.targetDir = targetDir;
        up.targetFile = new File(targetDir, name);
        return up;
    }

    private UpdateOptions() {
    }

    public File getFile() {
        return this.file;
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isSnapshotVersion() {
        return this.version.contains("-SNAPSHOT");
    }

    public String getPackageId() {
        return this.pkgId;
    }

    public void setUpgradeOnly(boolean upgradeOnly) {
        this.upgradeOnly = upgradeOnly;
    }

    public void setAllowDowngrade(boolean allowDowngrade) {
        this.allowDowngrade = allowDowngrade;
    }

    public boolean isUpgradeOnly() {
        return this.upgradeOnly;
    }

    public boolean isAllowDowngrade() {
        return this.allowDowngrade;
    }

    public void setDeleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }
}

