/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryServiceImpl;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractReference
implements Reference {
    protected DirectoryServiceImpl directoryService;
    protected String sourceDirectoryName;
    protected Directory sourceDirectory;
    protected String targetDirectoryName;
    protected Directory targetDirectory;
    protected String fieldName;

    public String getFieldName() {
        return this.fieldName;
    }

    public Directory getSourceDirectory() throws DirectoryException {
        if (this.sourceDirectory == null) {
            this.sourceDirectory = this.getDirectoryService().getDirectory(this.sourceDirectoryName);
        }
        return this.sourceDirectory;
    }

    public void setSourceDirectoryName(String sourceDirectoryName) {
        this.sourceDirectory = null;
        this.sourceDirectoryName = sourceDirectoryName;
    }

    public Directory getTargetDirectory() throws DirectoryException {
        if (this.targetDirectory == null) {
            this.targetDirectory = this.getDirectoryService().getDirectory(this.targetDirectoryName);
        }
        return this.targetDirectory;
    }

    public void setTargetDirectoryName(String targetDirectoryName) {
        this.targetDirectory = null;
        this.targetDirectoryName = targetDirectoryName;
    }

    protected DirectoryServiceImpl getDirectoryService() {
        if (this.directoryService == null) {
            this.directoryService = (DirectoryServiceImpl)((Object)Framework.getRuntime().getComponent(DirectoryService.NAME));
        }
        return this.directoryService;
    }

    public AbstractReference clone() {
        AbstractReference clone = this.newInstance();
        clone.sourceDirectoryName = this.sourceDirectoryName;
        clone.targetDirectoryName = this.targetDirectoryName;
        clone.fieldName = this.fieldName;
        return clone;
    }

    protected abstract AbstractReference newInstance();
}

