/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.magger;

import java.io.IOException;
import java.net.URI;
import java.util.Stack;
import org.apache.batik.css.engine.sac.ExtendedSelector;
import org.milyn.magger.CSSParser;
import org.milyn.magger.CSSProperty;
import org.milyn.magger.CSSRule;
import org.milyn.magger.CSSStylesheet;
import org.milyn.resource.ExternalResourceLocator;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;

class CSSDocumentHandler
implements DocumentHandler {
    private URI baseURI;
    private Stack mediaStack = new Stack();
    private CSSStylesheet stylesheet;
    private SelectorList curSelectors;
    private ExternalResourceLocator resourceLocator;

    CSSDocumentHandler(CSSStylesheet stylesheet, URI baseURI, SACMediaList media, ExternalResourceLocator resourceLocator) {
        this.stylesheet = stylesheet;
        this.baseURI = baseURI;
        if (media != null) {
            this.mediaStack.push(media);
        }
        this.resourceLocator = resourceLocator;
    }

    public void startMedia(SACMediaList media) throws CSSException {
        this.mediaStack.push(media);
    }

    public void endMedia(SACMediaList media) throws CSSException {
        this.mediaStack.pop();
    }

    public void startSelector(SelectorList selectors) throws CSSException {
        this.curSelectors = selectors;
    }

    public void endSelector(SelectorList selectors) throws CSSException {
        this.curSelectors = null;
    }

    public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        URI importURI = this.baseURI.resolve(uri);
        CSSParser parser = new CSSParser(this.resourceLocator);
        try {
            if (media != null) {
                parser.parse(importURI, media, this.stylesheet);
            } else {
                parser.parse(importURI, this.getCurrentMedia(), this.stylesheet);
            }
        }
        catch (IOException e) {
            throw new CSSException((Exception)e);
        }
    }

    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
        CSSProperty property = new CSSProperty(name.intern(), value, important);
        SACMediaList mediaList = this.getCurrentMedia();
        int selectorCount = this.curSelectors.getLength();
        for (int i = 0; i < selectorCount; ++i) {
            ExtendedSelector selector = (ExtendedSelector)this.curSelectors.item(i);
            this.stylesheet.addRule(new CSSRule(selector, property, mediaList));
        }
    }

    private SACMediaList getCurrentMedia() {
        SACMediaList mediaList = !this.mediaStack.isEmpty() ? (SACMediaList)this.mediaStack.peek() : null;
        return mediaList;
    }

    public void startDocument(InputSource source) throws CSSException {
    }

    public void endDocument(InputSource source) throws CSSException {
    }

    public void comment(String text) throws CSSException {
    }

    public void ignorableAtRule(String atRule) throws CSSException {
    }

    public void startPage(String name, String pseudo_page) throws CSSException {
    }

    public void endPage(String name, String pseudo_page) throws CSSException {
    }

    public void startFontFace() throws CSSException {
    }

    public void endFontFace() throws CSSException {
    }

    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
    }
}

