/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.localconfiguration.web.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.types.localconfiguration.UITypesConfiguration;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;

@Name(value="typesConfigurationActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class UITypesConfigurationActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Comparator<? super Type> TYPE_ALPHABETICAL_ORDER = new Comparator<Type>(){

        @Override
        public int compare(Type type1, Type type2) {
            return type1.getId().compareTo(type2.getId());
        }
    };
    @In(create=true)
    protected transient TypeManager typeManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    protected transient SchemaManager schemaManager;

    public List<Type> getNotSelectedTypes() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.getNotSelectedTypes(currentDoc);
    }

    public List<Type> getNotSelectedTypes(DocumentModel document) throws ClientException {
        if (!document.hasFacet("UITypesLocalConfiguration")) {
            return Collections.emptyList();
        }
        List<String> allowedTypes = this.getAllowedTypes(document);
        ArrayList<Type> notSelectedTypes = new ArrayList<Type>(this.typeManager.findAllAllowedSubTypesFrom(document.getType()));
        Iterator it = notSelectedTypes.iterator();
        while (it.hasNext()) {
            Type type = (Type)it.next();
            if (!allowedTypes.contains(type.getId())) continue;
            it.remove();
        }
        Collections.sort(notSelectedTypes, TYPE_ALPHABETICAL_ORDER);
        return notSelectedTypes;
    }

    protected List<String> getAllowedTypes(DocumentModel doc) throws ClientException {
        UITypesConfiguration uiTypesConfiguration = (UITypesConfiguration)doc.getAdapter(UITypesConfiguration.class);
        if (uiTypesConfiguration == null) {
            return Collections.emptyList();
        }
        List<String> allowedTypes = new ArrayList<String>(uiTypesConfiguration.getAllowedTypes());
        if (allowedTypes.isEmpty()) {
            allowedTypes = this.computeAllowedTypes(doc);
        }
        return allowedTypes;
    }

    public List<Type> getSelectedTypes() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.getSelectedTypes(currentDoc);
    }

    public List<Type> getSelectedTypes(DocumentModel document) throws ClientException {
        if (!document.hasFacet("UITypesLocalConfiguration")) {
            return Collections.emptyList();
        }
        List<String> allowedTypes = this.getAllowedTypes(document);
        Collections.sort(allowedTypes);
        ArrayList<Type> selectedTypes = new ArrayList<Type>();
        for (String type : allowedTypes) {
            selectedTypes.add(this.typeManager.getType(type));
        }
        return selectedTypes;
    }

    protected List<String> computeAllowedTypes(DocumentModel currentDoc) throws ClientException {
        ArrayList<String> types = new ArrayList<String>();
        DocumentModel parent = this.documentManager.getRootDocument();
        DocumentRef ref = currentDoc.getRef();
        if (ref != null) {
            parent = this.documentManager.getParentDocument(ref);
        }
        for (Type type : this.typeManager.findAllAllowedSubTypesFrom(currentDoc.getType(), parent)) {
            types.add(type.getId());
        }
        return types;
    }

    public List<Type> getTypesWithSchemaFile() throws ClientException {
        DocumentModel document = this.navigationContext.getCurrentDocument();
        return this.getTypesWithSchemaFile(document);
    }

    public List<Type> getTypesWithSchemaFile(DocumentModel document) throws ClientException {
        ArrayList<Type> types = new ArrayList<Type>();
        for (String type : this.getAllowedTypes(document)) {
            DocumentType documentType = this.getSchemaManager().getDocumentType(type);
            if (documentType == null || !documentType.hasSchema("file")) continue;
            types.add(this.typeManager.getType(type));
        }
        Collections.sort(types, TYPE_ALPHABETICAL_ORDER);
        return Collections.unmodifiableList(types);
    }

    protected SchemaManager getSchemaManager() throws ClientException {
        if (this.schemaManager == null) {
            try {
                this.schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            }
            catch (Exception e) {
                throw new ClientException("can NOT obtain schema manager", (Throwable)e);
            }
        }
        return this.schemaManager;
    }
}

