/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication.restAPI;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.syndication.serializer.ResultSummary;
import org.nuxeo.ecm.platform.syndication.serializer.SerializerHelper;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class SyndicationRestlet
extends BaseStatelessNuxeoRestlet {
    private String syndicationFormat = "RSS";

    protected void doHandleStatelessRequest(Request request, Response response) {
        String repo = (String)request.getAttributes().get("repo");
        String docid = (String)request.getAttributes().get("docid");
        this.initializeSyndicationFormat(request);
        ResultSummary summary = new ResultSummary();
        try {
            super.initRepositoryAndTargetDocument(response, repo, docid);
            DocumentModel currentDocument = this.session.getDocument((DocumentRef)new IdRef(docid));
            summary.setAuthor(((String[])currentDocument.getProperty("dublincore", "contributors"))[0]);
            summary.setDescription((String)currentDocument.getProperty("dublincore", "description"));
            summary.setTitle((String)currentDocument.getProperty("dublincore", "title"));
            Date modDate = ((Calendar)currentDocument.getProperty("dublincore", "modified")).getTime();
            summary.setModificationDate(modDate);
            summary.setLink(SyndicationRestlet.getRestletFullUrl((Request)request));
            DocumentModelListImpl currentDocumentChildren = new DocumentModelListImpl();
            currentDocumentChildren.addAll((Collection)this.getChildrenDocument(this.session.getChildren(currentDocument.getRef())));
            SerializerHelper.formatResult(summary, (DocumentModelList)currentDocumentChildren, response, this.syndicationFormat, null, SyndicationRestlet.getHttpRequest((Request)request));
        }
        catch (Exception e) {
            response.setEntity(e.getMessage(), MediaType.TEXT_PLAIN);
        }
    }

    private DocumentModelList getChildrenDocument(DocumentModelList children) throws ClientException {
        DocumentModelListImpl allChildren = new DocumentModelListImpl();
        for (DocumentModel child : children) {
            if (child.getRef() == null) continue;
            allChildren.add((Object)this.session.getDocument(child.getRef()));
        }
        return allChildren;
    }

    private void initializeSyndicationFormat(Request request) {
        String format = (String)request.getResourceRef().getSegments().get(4);
        if (format.equals("atom")) {
            this.syndicationFormat = "ATOM";
        } else if (format.equals("rss")) {
            this.syndicationFormat = "RSS";
        }
    }
}

