/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication.serializer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.syndication.serializer.AbstractDocumentModelSerializer;
import org.nuxeo.ecm.platform.syndication.serializer.ResultField;
import org.nuxeo.ecm.platform.syndication.serializer.ResultSummary;
import org.nuxeo.ecm.platform.syndication.translate.TranslationHelper;
import org.restlet.data.MediaType;
import org.restlet.data.Response;

public class DMJSONSerializer
extends AbstractDocumentModelSerializer {
    @Override
    public String serialize(ResultSummary summary, DocumentModelList docList, List<String> columnsDefinition, HttpServletRequest req) throws ClientException {
        return this.serialize(summary, docList, columnsDefinition, req, null, null);
    }

    public String serialize(ResultSummary summary, DocumentModelList docList, List<String> columnsDefinition, HttpServletRequest req, List<String> labels, String lang) throws ClientException {
        if (docList == null) {
            return "empty result";
        }
        HashMap<String, Object> all = new HashMap<String, Object>();
        all.put("summary", summary);
        ArrayList struct = new ArrayList();
        for (DocumentModel doc : docList) {
            HashMap<String, String> resDoc = new HashMap<String, String>();
            resDoc.put("id", doc.getId());
            for (String colDef : columnsDefinition) {
                ResultField res = this.getDocumentProperty(doc, colDef);
                resDoc.put(res.getName(), res.getValue());
            }
            struct.add(resDoc);
        }
        all.put("data", struct);
        if (lang != null && labels != null) {
            HashMap<String, String> translations = new HashMap<String, String>();
            for (String key : labels) {
                translations.put(key, TranslationHelper.getLabel(key, lang));
            }
            all.put("translations", translations);
        }
        return DMJSONSerializer.makeJSON(all);
    }

    protected static String makeJSON(Map<String, Object> all) {
        JSON jsonRes = JSONSerializer.toJSON(all);
        if (jsonRes instanceof JSONObject) {
            JSONObject jsonOb = (JSONObject)jsonRes;
            return jsonOb.toString(2);
        }
        if (jsonRes instanceof JSONArray) {
            JSONArray jsonOb = (JSONArray)jsonRes;
            return jsonOb.toString(2);
        }
        return null;
    }

    @Override
    public void serialize(ResultSummary summary, DocumentModelList docList, String columnsDefinition, Response res, HttpServletRequest req) throws ClientException {
        String json = this.serialize(summary, docList, columnsDefinition, req);
        res.setEntity(json, MediaType.TEXT_PLAIN);
    }

    @Override
    public void serialize(ResultSummary summary, DocumentModelList docList, String columnsDefinition, Response res, HttpServletRequest req, List<String> labels, String lang) throws ClientException {
        List<String> cols = new ArrayList<String>();
        if (columnsDefinition != null) {
            cols = Arrays.asList(columnsDefinition.split(","));
        }
        String json = this.serialize(summary, docList, cols, req, labels, lang);
        res.setEntity(json, MediaType.TEXT_PLAIN);
    }
}

