/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.syndication.serializer;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.syndication.serializer.AbstractDocumentModelSerializer;
import org.nuxeo.ecm.platform.syndication.serializer.ResultField;
import org.nuxeo.ecm.platform.syndication.serializer.ResultSummary;
import org.w3c.dom.Element;

public class SimpleXMLSerializer
extends AbstractDocumentModelSerializer {
    private static final String rootNodeName = "results";
    private static final String docNodeName = "document";

    @Override
    public String serialize(ResultSummary summary, DocumentModelList docList, List<String> columnsDefinition, HttpServletRequest req) throws ClientException {
        if (docList == null) {
            return "empty result";
        }
        DOMDocumentFactory domfactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domfactory.createDocument();
        Element current = result.createElement(rootNodeName);
        result.setRootElement((org.dom4j.Element)current);
        Element pagesElement = result.createElement("pages");
        pagesElement.setAttribute("pages", Integer.toString(summary.getPages()));
        pagesElement.setAttribute("pageNumber", Integer.toString(summary.getPageNumber()));
        current.appendChild(pagesElement);
        for (DocumentModel doc : docList) {
            Element el = result.createElement(docNodeName);
            el.setAttribute("id", doc.getId());
            for (String colDef : columnsDefinition) {
                ResultField res = this.getDocumentProperty(doc, colDef);
                el.setAttribute(res.getName(), res.getValue());
            }
            current.appendChild(el);
        }
        return result.asXML();
    }
}

