/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.localfs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.publisher.api.AbstractBasePublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.impl.localfs.FSPublicationNode;
import org.nuxeo.ecm.platform.publisher.impl.localfs.FSPublishedDocument;
import org.nuxeo.ecm.platform.publisher.impl.localfs.FSPublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.impl.localfs.NotFSPublishedDocumentException;

public class LocalFSPublicationTree
extends AbstractBasePublicationTree
implements PublicationTree {
    private static final long serialVersionUID = 1L;
    public static final String INDEX_FILENAME = "fspublication.index";
    public static final String INDEX_FILENAME_TMP = "fspublication.index.tmp";

    public void initTree(String sid, CoreSession coreSession, Map<String, String> parameters, PublishedDocumentFactory factory, String configName, String title) throws ClientException {
        super.initTree(sid, coreSession, parameters, factory, configName, title);
        try {
            this.rootNode = new FSPublicationNode(this.rootPath, this.getTreeConfigName(), sid);
        }
        catch (IllegalArgumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected PublishedDocumentFactory getDefaultFactory() {
        return new FSPublishedDocumentFactory();
    }

    protected String getDefaultRootPath() {
        return "/";
    }

    protected void findDocs(List<PublishedDocument> pubDocs, File container, DocumentLocation docLoc) {
        for (File child : container.listFiles()) {
            if (child.isDirectory()) {
                this.findDocs(pubDocs, child, docLoc);
                continue;
            }
            try {
                FSPublishedDocument pubDoc = new FSPublishedDocument(child);
                if (!pubDoc.getSourceRepositoryName().equals(docLoc.getServerName()) || !pubDoc.getSourceDocumentRef().equals(docLoc.getDocRef())) continue;
                pubDocs.add(pubDoc);
            }
            catch (NotFSPublishedDocumentException e) {
                // empty catch block
            }
        }
    }

    public List<PublishedDocument> getExistingPublishedDocument(DocumentLocation docLoc) throws ClientException {
        List<PublishedDocument> pubDocs = null;
        pubDocs = this.loadExistingPublishedDocumentFromIndex(docLoc);
        if (pubDocs == null) {
            pubDocs = new ArrayList<PublishedDocument>();
            File root = new File(this.getPath());
            this.findDocs(pubDocs, root, docLoc);
            this.createIndex(pubDocs);
        }
        return pubDocs;
    }

    private List<PublishedDocument> loadExistingPublishedDocumentFromIndex(DocumentLocation docLoc) throws ClientException {
        File indexFile = new File(this.rootPath, INDEX_FILENAME);
        if (!indexFile.exists() || !indexFile.isFile()) {
            return null;
        }
        ArrayList<PublishedDocument> pubDocs = new ArrayList<PublishedDocument>();
        BufferedReader reader = null;
        try {
            String filePath;
            reader = new BufferedReader(new FileReader(indexFile));
            while ((filePath = reader.readLine()) != null) {
                FSPublishedDocument pubDoc;
                File file = new File(filePath);
                if (!file.exists() || !(pubDoc = new FSPublishedDocument(file)).getSourceRepositoryName().equals(docLoc.getServerName()) || !pubDoc.getSourceDocumentRef().equals(docLoc.getDocRef())) continue;
                pubDocs.add(pubDoc);
            }
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return pubDocs;
    }

    private void createIndex(List<PublishedDocument> pubDocs) throws ClientException {
        File indexFile = new File(this.rootPath, INDEX_FILENAME);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(indexFile));
            for (PublishedDocument pubDoc : pubDocs) {
                writer.write(pubDoc.getPath());
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void addToIndex(PublishedDocument pubDoc) throws ClientException {
        File fileIndex = new File(this.rootPath, INDEX_FILENAME);
        File fileIndexTmp = new File(this.rootPath, INDEX_FILENAME_TMP);
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            String line;
            if (!fileIndex.exists()) {
                fileIndex.createNewFile();
            }
            reader = new BufferedReader(new FileReader(fileIndex));
            writer = new BufferedWriter(new FileWriter(fileIndexTmp));
            String pathToAdd = pubDoc.getPath();
            boolean pathAlreadyFound = false;
            while ((line = reader.readLine()) != null) {
                if (line.equals(pathToAdd)) {
                    pathAlreadyFound = true;
                }
                writer.write(line);
                writer.newLine();
            }
            if (!pathAlreadyFound) {
                writer.write(pathToAdd);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
        if (fileIndex.delete()) {
            this.moveFile(fileIndexTmp, fileIndex);
        }
    }

    private void moveFile(File srcFile, File destFile) throws ClientException {
        try {
            FileUtils.moveFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
    }

    private void removeFromIndex(PublishedDocument pubDoc) throws ClientException {
        File fileIndex = new File(this.rootPath, INDEX_FILENAME);
        File fileIndexTmp = new File(this.rootPath, INDEX_FILENAME_TMP);
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(fileIndex));
            writer = new BufferedWriter(new FileWriter(fileIndexTmp));
            String pathToRemove = pubDoc.getPath();
            while ((line = reader.readLine()) != null) {
                if (pathToRemove.equals(line)) continue;
                writer.write(line);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
        if (fileIndex.delete()) {
            this.moveFile(fileIndexTmp, fileIndex);
        }
    }

    public PublicationNode getNodeByPath(String path) throws ClientException {
        return new FSPublicationNode(path, this.getTreeConfigName(), this.getSessionId());
    }

    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode) throws ClientException {
        PublishedDocument pubDoc = super.publish(doc, targetNode);
        this.addToIndex(pubDoc);
        return pubDoc;
    }

    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) throws ClientException {
        PublishedDocument pubDoc = super.publish(doc, targetNode, params);
        this.addToIndex(pubDoc);
        return pubDoc;
    }

    public void unpublish(DocumentModel doc, PublicationNode targetNode) throws ClientException {
        File container = new File(targetNode.getPath());
        for (File child : container.listFiles()) {
            try {
                this.unpublish(doc, child);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void unpublish(DocumentModel doc, File file) throws ClientException {
        FSPublishedDocument pubDoc = new FSPublishedDocument(file);
        if (pubDoc.getSourceRepositoryName().equals(doc.getRepositoryName()) && pubDoc.getSourceDocumentRef().equals(doc.getRef())) {
            new File(pubDoc.getPersistPath()).delete();
            this.removeFromIndex(pubDoc);
        }
    }

    public void unpublish(PublishedDocument pubDoc) throws ClientException {
        if (!this.accept(pubDoc)) {
            return;
        }
        FSPublishedDocument fsPublishedDocument = (FSPublishedDocument)pubDoc;
        new File(fsPublishedDocument.getPersistPath()).delete();
        this.removeFromIndex(pubDoc);
    }

    public void release() {
    }

    protected boolean accept(PublishedDocument publishedDocument) {
        return publishedDocument instanceof FSPublishedDocument;
    }
}

