/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import java.util.Stack;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.Area;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.Function;
import jxl.biff.formula.Operator;
import jxl.biff.formula.ParseItem;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

class VariableArgFunction
extends Operator
implements ParsedThing {
    private static Log logger = Logging.getLog(VariableArgFunction.class);
    private Function function;
    private int arguments;
    private boolean readFromSheet;
    private WorkbookSettings settings;

    public VariableArgFunction(WorkbookSettings ws) {
        this.readFromSheet = true;
        this.settings = ws;
    }

    public VariableArgFunction(Function f, int a, WorkbookSettings ws) {
        this.function = f;
        this.arguments = a;
        this.readFromSheet = false;
        this.settings = ws;
    }

    public int read(byte[] data, int pos) throws FormulaException {
        this.arguments = data[pos];
        int index = IntegerHelper.getInt(data[pos + 1], data[pos + 2]);
        this.function = Function.getFunction(index);
        if (this.function == Function.UNKNOWN) {
            throw new FormulaException(FormulaException.UNRECOGNIZED_FUNCTION, index);
        }
        return 3;
    }

    public void getOperands(Stack s) {
        ParseItem[] items = new ParseItem[this.arguments];
        int i = this.arguments - 1;
        while (i >= 0) {
            ParseItem pi;
            items[i] = pi = (ParseItem)s.pop();
            --i;
        }
        i = 0;
        while (i < this.arguments) {
            this.add(items[i]);
            ++i;
        }
    }

    public void getString(StringBuffer buf) {
        buf.append(this.function.getName(this.settings));
        buf.append('(');
        if (this.arguments > 0) {
            ParseItem[] operands = this.getOperands();
            if (this.readFromSheet) {
                operands[0].getString(buf);
                int i = 1;
                while (i < this.arguments) {
                    buf.append(',');
                    operands[i].getString(buf);
                    ++i;
                }
            } else {
                operands[this.arguments - 1].getString(buf);
                int i = this.arguments - 2;
                while (i >= 0) {
                    buf.append(',');
                    operands[i].getString(buf);
                    --i;
                }
            }
        }
        buf.append(')');
    }

    public void adjustRelativeCellReferences(int colAdjust, int rowAdjust) {
        ParseItem[] operands = this.getOperands();
        int i = 0;
        while (i < operands.length) {
            operands[i].adjustRelativeCellReferences(colAdjust, rowAdjust);
            ++i;
        }
    }

    void columnInserted(int sheetIndex, int col, boolean currentSheet) {
        ParseItem[] operands = this.getOperands();
        int i = 0;
        while (i < operands.length) {
            operands[i].columnInserted(sheetIndex, col, currentSheet);
            ++i;
        }
    }

    void columnRemoved(int sheetIndex, int col, boolean currentSheet) {
        ParseItem[] operands = this.getOperands();
        int i = 0;
        while (i < operands.length) {
            operands[i].columnRemoved(sheetIndex, col, currentSheet);
            ++i;
        }
    }

    void rowInserted(int sheetIndex, int row, boolean currentSheet) {
        ParseItem[] operands = this.getOperands();
        int i = 0;
        while (i < operands.length) {
            operands[i].rowInserted(sheetIndex, row, currentSheet);
            ++i;
        }
    }

    void rowRemoved(int sheetIndex, int row, boolean currentSheet) {
        ParseItem[] operands = this.getOperands();
        int i = 0;
        while (i < operands.length) {
            operands[i].rowRemoved(sheetIndex, row, currentSheet);
            ++i;
        }
    }

    void handleImportedCellReferences() {
        ParseItem[] operands = this.getOperands();
        int i = 0;
        while (i < operands.length) {
            operands[i].handleImportedCellReferences();
            ++i;
        }
    }

    Function getFunction() {
        return this.function;
    }

    byte[] getBytes() {
        this.handleSpecialCases();
        ParseItem[] operands = this.getOperands();
        byte[] data = new byte[]{};
        int i = 0;
        while (i < operands.length) {
            byte[] opdata = operands[i].getBytes();
            byte[] newdata = new byte[data.length + opdata.length];
            System.arraycopy(data, 0, newdata, 0, data.length);
            System.arraycopy(opdata, 0, newdata, data.length, opdata.length);
            data = newdata;
            ++i;
        }
        byte[] newdata = new byte[data.length + 4];
        System.arraycopy(data, 0, newdata, 0, data.length);
        newdata[data.length] = !this.useAlternateCode() ? Token.FUNCTIONVARARG.getCode() : Token.FUNCTIONVARARG.getCode2();
        newdata[data.length + 1] = (byte)this.arguments;
        IntegerHelper.getTwoBytes(this.function.getCode(), newdata, data.length + 2);
        return newdata;
    }

    int getPrecedence() {
        return 3;
    }

    private void handleSpecialCases() {
        if (this.function == Function.SUMPRODUCT) {
            ParseItem[] operands = this.getOperands();
            int i = operands.length - 1;
            while (i >= 0) {
                if (operands[i] instanceof Area) {
                    operands[i].setAlternateCode();
                }
                --i;
            }
        }
    }
}

