/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.themes;

import java.util.Arrays;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="theme")
public class ThemeSetEntry {
    @XNode(value="@name")
    public String name;
    @XNode(value="@features")
    public String features = "";

    public ThemeSetEntry() {
    }

    public ThemeSetEntry(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getFeatures() {
        return Arrays.asList(this.features.split(","));
    }

    public void addFeature(String feature) {
        if (!this.getFeatures().contains(feature)) {
            this.features = this.features + this.features.concat(",").concat(feature);
        }
    }

    public void removeFeature(String feature) {
        List<String> featuresList = this.getFeatures();
        this.features = "";
        for (String f : featuresList) {
            if (f.equals(feature)) continue;
            this.addFeature(f);
        }
    }
}

