/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.vocabularies;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.Registrable;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.vocabularies.Vocabulary;
import org.nuxeo.theme.vocabularies.VocabularyItem;
import org.nuxeo.theme.vocabularies.VocabularyType;

public final class VocabularyManager
implements Registrable {
    private static final Log log = LogFactory.getLog(VocabularyManager.class);
    private final Map<String, Vocabulary> vocabularies = new HashMap<String, Vocabulary>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VocabularyItem> getItems(String name) {
        VocabularyType vocabularyType = (VocabularyType)Manager.getTypeRegistry().lookup(TypeFamily.VOCABULARY, name);
        if (vocabularyType == null) {
            return null;
        }
        String path = vocabularyType.getPath();
        String className = vocabularyType.getClassName();
        if (path == null && className == null) {
            log.error((Object)("Must specify a class name or a path for vocabulary: " + name));
            return null;
        }
        if (path != null && className != null) {
            log.error((Object)("Cannot specify both a class name and a path for vocabulary: " + name));
            return null;
        }
        if (className != null) {
            Vocabulary vocabulary = this.getInstance(className);
            if (vocabulary == null) {
                log.error((Object)("Vocabulary class not found: " + className));
                return null;
            }
            return vocabulary.getItems();
        }
        if (path != null) {
            if (!path.endsWith(".csv")) {
                log.error((Object)("Only .csv vocabularies are supported: " + path));
                return null;
            }
            ArrayList<VocabularyItem> items = new ArrayList<VocabularyItem>();
            CSVReader reader = null;
            InputStream is = null;
            try {
                String[] line;
                is = this.getClass().getClassLoader().getResourceAsStream(path);
                if (is == null) {
                    log.error((Object)("Vocabulary file not found: " + path));
                    List<VocabularyItem> list = null;
                    return list;
                }
                reader = new CSVReader((Reader)new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readNext()) != null) {
                    String value;
                    String label = value = line[0];
                    if (line.length >= 2) {
                        label = line[1];
                    }
                    items.add(new VocabularyItem(value, label));
                }
            }
            catch (IOException e) {
                log.error((Object)("Could not read vocabulary file: " + path), (Throwable)e);
            }
            finally {
                try {
                    is.close();
                    reader.close();
                }
                catch (Exception e) {}
            }
            return items;
        }
        return null;
    }

    private Vocabulary getInstance(String className) {
        Vocabulary vocabulary = this.vocabularies.get(className);
        if (vocabulary == null) {
            try {
                vocabulary = (Vocabulary)Class.forName(className).newInstance();
            }
            catch (InstantiationException e) {
                log.error((Object)("Could not instantiate vocabulary: " + className));
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Could not instantiate vocabulary: " + className));
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Could not instantiate vocabulary: " + className));
            }
        }
        if (vocabulary != null) {
            this.vocabularies.put(className, vocabulary);
        }
        return vocabulary;
    }

    @Override
    public void clear() {
    }
}

