/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import org.javasimon.Stopwatch;
import org.javasimon.StopwatchImpl;
import org.javasimon.utils.SimonUtils;

public final class Split {
    private Stopwatch stopwatch;
    private long start;
    private long total;
    private boolean enabled;

    Split(Stopwatch stopwatch, long start) {
        this.stopwatch = stopwatch;
        this.enabled = stopwatch.isEnabled();
        this.start = start;
    }

    public Stopwatch getStopwatch() {
        return this.stopwatch;
    }

    public long stop() {
        if (this.enabled && this.start != 0L) {
            this.total = ((StopwatchImpl)this.stopwatch).stop(this, this.start);
            this.start = 0L;
            return this.total;
        }
        return 0L;
    }

    public long runningFor() {
        if (this.total != 0L) {
            return this.total;
        }
        if (this.enabled) {
            return System.nanoTime() - this.start;
        }
        return 0L;
    }

    public String presentRunningFor() {
        return SimonUtils.presentNanoTime(this.runningFor());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        if (!this.enabled) {
            return "Split created from disabled Stopwatch";
        }
        if (this.total == 0L) {
            return "Running split for Stopwatch '" + this.stopwatch.getName() + "': " + SimonUtils.presentNanoTime(this.runningFor());
        }
        return "Stopped split for Stopwatch '" + this.stopwatch.getName() + "': " + SimonUtils.presentNanoTime(this.total);
    }
}

