/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.javasimon.Callback;
import org.javasimon.Manager;
import org.javasimon.Simon;

public final class SimonUtils {
    public static final long NANOS_IN_MILLIS = 1000000L;
    public static final Pattern NAME_PATTERN = Pattern.compile("[-_\\[\\]A-Za-z0-9.,@$%()<>]+");
    public static final String ALLOWED_CHARS = "-_[]ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstvwxyz0123456789.,@$%()<>";
    private static final int UNIT_PREFIX_FACTOR = 1000;
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyMMdd-HHmmss.SSS");
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    private static final int TEN = 10;
    private static final DecimalFormat UNDER_TEN_FORMAT = new DecimalFormat("0.00", DECIMAL_FORMAT_SYMBOLS);
    private static final int HUNDRED = 100;
    private static final DecimalFormat UNDER_HUNDRED_FORMAT = new DecimalFormat("00.0", DECIMAL_FORMAT_SYMBOLS);
    private static final DecimalFormat DEFAULT_FORMAT = new DecimalFormat("000", DECIMAL_FORMAT_SYMBOLS);
    private static final String UNDEF_STRING = "undef";
    private static final int CLIENT_CODE_STACK_INDEX;

    private SimonUtils() {
        throw new UnsupportedOperationException();
    }

    public static String presentNanoTime(long nanos) {
        if (nanos == Long.MAX_VALUE) {
            return UNDEF_STRING;
        }
        if (nanos < 1000L) {
            return nanos + " ns";
        }
        double time = nanos;
        if ((time /= 1000.0) < 1000.0) {
            return SimonUtils.formatTime(time, " us");
        }
        if ((time /= 1000.0) < 1000.0) {
            return SimonUtils.formatTime(time, " ms");
        }
        return SimonUtils.formatTime(time /= 1000.0, " s");
    }

    private static String formatTime(double time, String unit) {
        if (time < 10.0) {
            return UNDER_TEN_FORMAT.format(time) + unit;
        }
        if (time < 100.0) {
            return UNDER_HUNDRED_FORMAT.format(time) + unit;
        }
        return DEFAULT_FORMAT.format(time) + unit;
    }

    public static String presentTimestamp(long timestamp) {
        if (timestamp == 0L) {
            return UNDEF_STRING;
        }
        return TIMESTAMP_FORMAT.format(new Date(timestamp));
    }

    public static String presentMinMaxCount(long minmax) {
        if (minmax == Long.MAX_VALUE || minmax == Long.MIN_VALUE) {
            return UNDEF_STRING;
        }
        return String.valueOf(minmax);
    }

    public static String presentMinMaxSplit(long minmax) {
        if (minmax == Long.MAX_VALUE || minmax == Long.MIN_VALUE) {
            return UNDEF_STRING;
        }
        return SimonUtils.presentNanoTime(minmax);
    }

    public static String simonTreeString(Simon simon) {
        if (simon == null || simon.getName() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        SimonUtils.printSimonTree(0, simon, sb);
        return sb.toString();
    }

    private static void printSimonTree(int level, Simon simon, StringBuilder sb) {
        SimonUtils.printSimon(level, simon, sb);
        for (Simon child : simon.getChildren()) {
            SimonUtils.printSimonTree(level + 1, child, sb);
        }
    }

    private static void printSimon(int level, Simon simon, StringBuilder sb) {
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        sb.append(SimonUtils.localName(simon.getName())).append('(').append(simon.isEnabled() ? (char)'+' : '-').append("): ").append(simon.toString()).append('\n');
    }

    public static String localName(String name) {
        int ix = name.lastIndexOf(".");
        if (ix == -1) {
            return name;
        }
        return name.substring(ix + 1);
    }

    public static void recursiveReset(Simon simon) {
        simon.reset();
        for (Simon child : simon.getChildren()) {
            SimonUtils.recursiveReset(child);
        }
    }

    public static boolean checkName(String name) {
        return NAME_PATTERN.matcher(name).matches();
    }

    public static void warning(String warning) {
        Logger.getLogger("org.javasimon").warning(warning);
    }

    public static String generateName(String suffix, boolean includeMethodName) {
        StackTraceElement stackElement = Thread.currentThread().getStackTrace()[CLIENT_CODE_STACK_INDEX];
        StringBuilder nameBuilder = new StringBuilder(stackElement.getClassName());
        if (includeMethodName) {
            nameBuilder.append('.').append(stackElement.getMethodName());
        }
        if (suffix != null) {
            nameBuilder.append(suffix);
        }
        return nameBuilder.toString();
    }

    public static void removeAllCallbacks(Manager manager) {
        Callback rootCallback = manager.callback();
        for (Callback callback : rootCallback.callbacks()) {
            rootCallback.removeCallback(callback);
        }
    }

    static {
        int i = 0;
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            ++i;
            if (ste.getClassName().equals(SimonUtils.class.getName())) break;
        }
        CLIENT_CODE_STACK_INDEX = i;
    }
}

