/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorBase;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorWrapper;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.Iterator;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.logging.Log;

public class QueryIteratorCheck
extends QueryIteratorWrapper {
    private ExecutionContext execCxt;

    private QueryIteratorCheck(QueryIterator qIter, ExecutionContext execCxt) {
        super(qIter);
        if (qIter instanceof QueryIteratorCheck) {
            Log.warn(this, "Checking checked iterator");
        }
        this.execCxt = execCxt;
    }

    public void close() {
        super.close();
        QueryIteratorCheck.checkForOpenIterators(this.execCxt);
    }

    @Deprecated
    public void abort() {
        super.abort();
        QueryIteratorCheck.checkForOpenIterators(this.execCxt);
    }

    public void output(IndentedWriter out, SerializationContext sCxt) {
        this.iterator.output(out, sCxt);
    }

    public static void checkForOpenIterators(ExecutionContext execContext) {
        QueryIteratorCheck.dump(execContext, false);
    }

    public static QueryIteratorCheck check(QueryIterator qIter, ExecutionContext execCxt) {
        if (qIter instanceof QueryIteratorCheck) {
            return (QueryIteratorCheck)qIter;
        }
        return new QueryIteratorCheck(qIter, execCxt);
    }

    private static void dump(ExecutionContext execContext, boolean includeAll) {
        Iterator<QueryIterator> iterAll;
        if (includeAll && (iterAll = execContext.listAllIterators()) != null) {
            while (iterAll.hasNext()) {
                QueryIterator qIter = iterAll.next();
                QueryIteratorCheck.warn(qIter, "Iterator: ");
            }
        }
        Iterator<QueryIterator> iterOpen = execContext.listOpenIterators();
        while (iterOpen.hasNext()) {
            QueryIterator qIterOpen = iterOpen.next();
            QueryIteratorCheck.warn(qIterOpen, "Open iterator: ");
        }
    }

    private static void warn(QueryIterator qIter, String str2) {
        str2 = str2 + Utils.className(qIter);
        if (qIter instanceof QueryIteratorBase) {
            QueryIteratorBase qIterBase = (QueryIteratorBase)qIter;
            QueryIter qIterLN = (QueryIter)qIter;
            str2 = str2 + "/" + qIterLN.getIteratorNumber();
            String x = qIterBase.debug();
            if (x.length() > 0) {
                str2 = str2 + " : " + x;
            }
        }
        Log.warn(QueryIteratorCheck.class, str2);
    }
}

