/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunction1;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.openjena.atlas.lib.Bytes;

public abstract class ExprDigest
extends ExprFunction1 {
    private final String digestName;
    private MessageDigest digestCache;

    public ExprDigest(Expr expr, String symbol, String digestName) {
        super(expr, symbol);
        this.digestName = digestName;
        try {
            this.digestCache = MessageDigest.getInstance(digestName);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new ARQInternalErrorException("Digest not provided in this Java system: " + digestName);
        }
    }

    private MessageDigest getDigest() {
        if (this.digestCache != null) {
            MessageDigest digest2 = null;
            try {
                digest2 = (MessageDigest)this.digestCache.clone();
                return digest2;
            }
            catch (CloneNotSupportedException ex) {
                this.digestCache = null;
            }
        }
        return this.createDigest();
    }

    private MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance(this.digestName);
        }
        catch (Exception ex2) {
            throw new ARQInternalErrorException(ex2);
        }
    }

    public NodeValue eval(NodeValue v) {
        Node n = v.asNode();
        if (!n.isLiteral()) {
            throw new ExprEvalException("Not a literal: " + v);
        }
        if (n.getLiteralLanguage() != null && !n.getLiteralLanguage().equals("")) {
            throw new ExprEvalException("Can't make a digest of an RDF term with a language tag");
        }
        if (n.getLiteralDatatype() != null && !XSDDatatype.XSDstring.equals(n.getLiteralDatatype())) {
            throw new ExprEvalException("Not a simple literal nor an XSD string");
        }
        try {
            MessageDigest digest = this.getDigest();
            String x = n.getLiteralLexicalForm();
            byte[] b = x.getBytes("UTF-8");
            byte[] d = digest.digest(b);
            String y = Bytes.asHexLC(d);
            return NodeValue.makeString(y);
        }
        catch (Exception ex2) {
            throw new ARQInternalErrorException(ex2);
        }
    }
}

