/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.io;

import java.io.IOException;
import java.io.InputStream;
import org.openjena.atlas.io.IO;

public final class InputStreamBuffered
extends InputStream {
    public static int DFT_BUFSIZE = 16384;
    private InputStream source;
    private byte[] buffer;
    private int buffLen = 0;
    private int idx = 0;
    private long count = 0L;

    public InputStreamBuffered(InputStream input) {
        this(input, DFT_BUFSIZE);
    }

    public InputStreamBuffered(InputStream input, int bufsize) {
        this.source = input;
        this.buffer = new byte[bufsize];
        this.idx = 0;
        this.buffLen = 0;
    }

    public int read() throws IOException {
        return this.advance();
    }

    public void close() throws IOException {
        this.source.close();
    }

    public final int advance() {
        if (this.idx >= this.buffLen) {
            this.fillArray();
        }
        if (this.buffLen >= 0) {
            byte ch = this.buffer[this.idx];
            ++this.idx;
            ++this.count;
            return ch & 0xFF;
        }
        return -1;
    }

    private int fillArray() {
        try {
            int x = this.source.read(this.buffer);
            this.idx = 0;
            this.buffLen = x;
            return x;
        }
        catch (IOException ex) {
            IO.exception(ex);
            return -1;
        }
    }
}

