/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.out;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.CharsetEncoder;
import org.openjena.atlas.io.BufferingWriter;
import org.openjena.atlas.lib.Chars;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.out.NodeToLabel;
import org.openjena.riot.out.OutputLangUtils;
import org.openjena.riot.system.Prologue;
import org.openjena.riot.system.SyntaxLabels;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinkQuadOutput
implements Sink<Quad> {
    private CharsetEncoder encoder = Chars.charsetUTF8.newEncoder();
    private Prologue prologue = null;
    private BufferingWriter out;
    private NodeToLabel labelPolicy = null;
    private Node lastS = null;
    private Node lastP = null;
    private Node lastO = null;
    private Node lastG = null;

    public SinkQuadOutput(OutputStream outs) {
        this(outs, null, SyntaxLabels.createNodeToLabel());
    }

    public SinkQuadOutput(OutputStream outs, Prologue prologue, NodeToLabel labels) {
        BufferingWriter.SinkOutputStream dest = new BufferingWriter.SinkOutputStream(outs);
        this.out = new BufferingWriter(dest);
        this.setPrologue(prologue);
        this.setLabelPolicy(labels);
    }

    public void setPrologue(Prologue prologue) {
        this.prologue = prologue;
    }

    public void setLabelPolicy(NodeToLabel labels) {
        this.labelPolicy = labels;
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void send(Quad quad) {
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g = quad.getGraph();
        OutputLangUtils.output((Writer)this.out, s, this.prologue, this.labelPolicy);
        this.out.output(" ");
        OutputLangUtils.output((Writer)this.out, p, this.prologue, this.labelPolicy);
        this.out.output(" ");
        OutputLangUtils.output((Writer)this.out, o, this.prologue, this.labelPolicy);
        if (SinkQuadOutput.outputGraphSlot(g)) {
            this.out.output(" ");
            OutputLangUtils.output((Writer)this.out, g, this.prologue, this.labelPolicy);
        }
        this.out.output(" .");
        this.out.output("\n");
    }

    private static boolean outputGraphSlot(Node g) {
        return g != null && g != Quad.tripleInQuad && !Quad.isDefaultGraph(g);
    }

    @Override
    public void close() {
        this.flush();
    }
}

