/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.system;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapWithScope<A, B, S> {
    private final ScopePolicy<A, B, S> scopePolicy;
    private final Allocator<A, B> allocator;

    protected MapWithScope(ScopePolicy<A, B, S> scopePolicy, Allocator<A, B> allocator) {
        this.scopePolicy = scopePolicy;
        this.allocator = allocator;
    }

    public B get(S scope, A item) {
        Map<A, B> map = this.scopePolicy.getScope(scope);
        B mappedItem = map.get(item);
        if (mappedItem == null) {
            mappedItem = this.allocator.create(item);
            map.put(item, mappedItem);
        }
        return mappedItem;
    }

    public B create() {
        return this.allocator.create(null);
    }

    public void clear() {
        this.scopePolicy.clear();
        this.allocator.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Allocator<A, B> {
        public B create(A var1);

        public void reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface ScopePolicy<A, B, S> {
        public Map<A, B> getScope(S var1);

        public void clear();
    }
}

