/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.userworkspace.core.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.platform.userworkspace.core.service.UserWorkspaceServiceImplComponent;
import org.nuxeo.runtime.api.Framework;

public class DefaultUserWorkspaceServiceImpl
implements UserWorkspaceService {
    private static final Log log = LogFactory.getLog(DefaultUserWorkspaceServiceImpl.class);
    private static final long serialVersionUID = 1L;
    protected String targetDomainName;

    protected String getDomainName(CoreSession userCoreSession, DocumentModel currentDocument) {
        if (this.targetDomainName == null) {
            RootDomainFinder finder = new RootDomainFinder(userCoreSession);
            try {
                finder.runUnrestricted();
            }
            catch (ClientException e) {
                log.error((Object)"Unable to find root domain for UserWorkspace", (Throwable)e);
                return null;
            }
            this.targetDomainName = finder.domaineName;
        }
        return this.targetDomainName;
    }

    protected static String getUserWorkspaceNameForUser(String userName) {
        return IdUtils.generateId((String)userName, (String)"-", (boolean)false, (int)30);
    }

    protected String computePathUserWorkspaceRoot(CoreSession userCoreSession, DocumentModel currentDocument) throws ClientException {
        String domainName = this.getDomainName(userCoreSession, currentDocument);
        if (domainName == null) {
            throw new ClientException("Unable to find root domain for UserWorkspace");
        }
        Path path = new Path("/" + domainName);
        path = path.append("UserWorkspaces");
        return path.toString();
    }

    protected String computePathForUserWorkspace(CoreSession userCoreSession, String userName, DocumentModel currentDocument) throws ClientException {
        String rootPath = this.computePathUserWorkspaceRoot(userCoreSession, currentDocument);
        Path path = new Path(rootPath);
        path = path.append(DefaultUserWorkspaceServiceImpl.getUserWorkspaceNameForUser(userName));
        return path.toString();
    }

    public DocumentModel getCurrentUserPersonalWorkspace(String userName, DocumentModel currentDocument) throws ClientException {
        if (currentDocument == null) {
            return null;
        }
        CoreSession userCoreSession = CoreInstance.getInstance().getSession(currentDocument.getSessionId());
        return this.getCurrentUserPersonalWorkspace(userName, userCoreSession, currentDocument);
    }

    public DocumentModel getCurrentUserPersonalWorkspace(CoreSession userCoreSession, DocumentModel context) throws ClientException {
        return this.getCurrentUserPersonalWorkspace(userCoreSession.getPrincipal().getName(), userCoreSession, context);
    }

    protected DocumentModel getCurrentUserPersonalWorkspace(String userName, CoreSession userCoreSession, DocumentModel context) throws ClientException {
        PathRef uwsDocRef = new PathRef(this.computePathForUserWorkspace(userCoreSession, userName, context));
        if (!userCoreSession.exists((DocumentRef)uwsDocRef)) {
            PathRef rootRef = new PathRef(this.computePathUserWorkspaceRoot(userCoreSession, context));
            uwsDocRef = this.createUserWorkspace(rootRef, uwsDocRef, userCoreSession, userName);
        }
        if (userCoreSession.getClass().getSimpleName().equals("LocalSession")) {
            userCoreSession.save();
        }
        return userCoreSession.getDocument((DocumentRef)uwsDocRef);
    }

    protected synchronized PathRef createUserWorkspace(PathRef rootRef, PathRef userWSRef, CoreSession userCoreSession, String userName) throws ClientException {
        UnrestrictedUWSCreator creator = new UnrestrictedUWSCreator(rootRef, userWSRef, userCoreSession, userName);
        creator.runUnrestricted();
        userWSRef = creator.userWSRef;
        rootRef = creator.rootRef;
        return userWSRef;
    }

    protected static DocumentModel createUserWorkspacesRoot(CoreSession unrestrictedSession, PathRef rootRef) throws ClientException {
        String parentPath = new Path(rootRef.toString()).removeLastSegments(1).toString();
        DocumentModel doc = unrestrictedSession.createDocumentModel(parentPath, "UserWorkspaces", "UserWorkspacesRoot");
        doc.setProperty("dublincore", "title", (Object)"UserWorkspaces");
        doc.setProperty("dublincore", "description", (Object)"");
        doc = unrestrictedSession.createDocument(doc);
        ACPImpl acp = new ACPImpl();
        ACE denyEverything = new ACE("Everyone", "Everything", false);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{denyEverything});
        acp.addACL((ACL)acl);
        doc.setACP((ACP)acp, true);
        return doc;
    }

    protected static DocumentModel createUserWorkspace(CoreSession unrestrictedSession, PathRef wsRef, String userName) throws ClientException {
        String parentPath = new Path(wsRef.toString()).removeLastSegments(1).toString();
        String wsName = new Path(wsRef.toString()).lastSegment();
        DocumentModel doc = unrestrictedSession.createDocumentModel(parentPath, wsName, "Workspace");
        doc.setProperty("dublincore", "title", (Object)DefaultUserWorkspaceServiceImpl.buildUserWorkspaceTitle(userName));
        doc.setProperty("dublincore", "description", (Object)"");
        doc = unrestrictedSession.createDocument(doc);
        ACPImpl acp = new ACPImpl();
        ACE grantEverything = new ACE(userName, "Everything", true);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{grantEverything});
        acp.addACL((ACL)acl);
        doc.setACP((ACP)acp, true);
        return doc;
    }

    public DocumentModel getUserPersonalWorkspace(String userName, DocumentModel context) throws ClientException {
        try {
            UnrestrictedUserWorkspaceFinder finder = new UnrestrictedUserWorkspaceFinder(userName, context);
            finder.runUnrestricted();
            return finder.getDetachedUserWorkspace();
        }
        catch (Exception e) {
            log.warn((Object)"Error while trying to get user workspace unrestricted");
            throw new ClientException((Throwable)e);
        }
    }

    public static String buildUserWorkspaceTitle(String userName) {
        String lastName;
        if (userName == null) {
            return null;
        }
        UserManager userManager = null;
        try {
            userManager = (UserManager)Framework.getService(UserManager.class);
        }
        catch (Exception e) {
            log.debug((Object)"failed to get user service", (Throwable)e);
        }
        if (userManager == null) {
            return userName;
        }
        NuxeoPrincipal principal = null;
        try {
            principal = userManager.getPrincipal(userName);
        }
        catch (ClientException e) {
            log.debug((Object)("failed to get principal" + userName), (Throwable)e);
        }
        if (principal == null) {
            return userName;
        }
        StringBuilder title = new StringBuilder();
        String firstName = principal.getFirstName();
        if (firstName != null && firstName.trim().length() > 0) {
            title.append(firstName);
        }
        if ((lastName = principal.getLastName()) != null && lastName.trim().length() > 0) {
            if (title.length() > 0) {
                title.append(" ");
            }
            title.append(lastName);
        }
        if (title.length() > 0) {
            return title.toString();
        }
        return userName;
    }

    protected class UnrestrictedUserWorkspaceFinder
    extends UnrestrictedSessionRunner {
        protected DocumentModel userWorkspace;
        protected String userName;
        protected DocumentModel context;

        protected UnrestrictedUserWorkspaceFinder(String userName, DocumentModel context) throws Exception {
            super(context.getCoreSession().getRepositoryName(), userName);
            this.userName = userName;
            this.context = context;
        }

        public void run() throws ClientException {
            this.userWorkspace = DefaultUserWorkspaceServiceImpl.this.getCurrentUserPersonalWorkspace(this.userName, this.session, this.context);
            if (this.userWorkspace != null) {
                this.userWorkspace.detach(true);
            }
        }

        public DocumentModel getDetachedUserWorkspace() throws ClientException {
            return this.userWorkspace;
        }
    }

    protected class UnrestrictedUWSCreator
    extends UnrestrictedSessionRunner {
        PathRef rootRef;
        PathRef userWSRef;
        String userName;

        public UnrestrictedUWSCreator(PathRef rootRef, PathRef userWSRef, CoreSession userCoreSession, String userName) {
            super(userCoreSession);
            this.rootRef = rootRef;
            this.userWSRef = userWSRef;
            this.userName = userName;
        }

        public void run() throws ClientException {
            if (!this.session.exists((DocumentRef)this.rootRef)) {
                DocumentModel root = null;
                try {
                    root = DefaultUserWorkspaceServiceImpl.createUserWorkspacesRoot(this.session, this.rootRef);
                }
                catch (Exception e) {
                    DefaultUserWorkspaceServiceImpl.this.targetDomainName = null;
                    this.rootRef = new PathRef(DefaultUserWorkspaceServiceImpl.this.computePathUserWorkspaceRoot(this.session, null));
                    root = DefaultUserWorkspaceServiceImpl.createUserWorkspacesRoot(this.session, this.rootRef);
                    this.userWSRef = new PathRef(DefaultUserWorkspaceServiceImpl.this.computePathForUserWorkspace(this.session, this.userName, null));
                }
                assert (root.getPathAsString().equals(this.rootRef.toString()));
            }
            if (!this.session.exists((DocumentRef)this.userWSRef)) {
                DocumentModel uw = DefaultUserWorkspaceServiceImpl.createUserWorkspace(this.session, this.userWSRef, this.userName);
                assert (uw.getPathAsString().equals(this.userWSRef.toString()));
            }
            this.session.save();
        }
    }

    protected class RootDomainFinder
    extends UnrestrictedSessionRunner {
        protected String domaineName;

        public RootDomainFinder(CoreSession userCoreSession) {
            super(userCoreSession);
        }

        public void run() throws ClientException {
            PathRef ref = new PathRef("/" + UserWorkspaceServiceImplComponent.getTargetDomainName());
            if (this.session.exists((DocumentRef)ref)) {
                this.domaineName = UserWorkspaceServiceImplComponent.getTargetDomainName();
                return;
            }
            DocumentModelList domains = this.session.query("select * from Domain order by dc:created");
            if (!domains.isEmpty()) {
                this.domaineName = ((DocumentModel)domains.get(0)).getName();
            }
        }
    }
}

