/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionFilter;
import org.nuxeo.ecm.platform.actions.ActionPropertiesDescriptor;
import org.nuxeo.ecm.platform.actions.ActionRegistry;
import org.nuxeo.ecm.platform.actions.DefaultActionFilter;
import org.nuxeo.ecm.platform.actions.FilterContributionHandler;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ActionContributionHandler
extends ContributionFragmentRegistry<Action> {
    protected ActionRegistry actionReg = new ActionRegistry();
    protected FilterContributionHandler filters;

    public ActionContributionHandler(FilterContributionHandler filters) {
        this.filters = filters;
    }

    public ActionRegistry getRegistry() {
        return this.actionReg;
    }

    public Action clone(Action object) {
        return object.clone();
    }

    public void contributionRemoved(String id, Action action) {
        this.actionReg.removeAction(id);
        ActionFilter[] localFilters = action.getFilters();
        if (localFilters != null) {
            for (ActionFilter filter : localFilters) {
                DefaultActionFilter f = (DefaultActionFilter)filter;
                f.setAppend(true);
                this.filters.removeContribution(f, true);
            }
        }
    }

    public void contributionUpdated(String actionId, Action action, Action origAction) {
        ActionFilter[] newFilters;
        ArrayList<String> newFilterIds = new ArrayList<String>();
        List<String> existingFilterIds = action.getFilterIds();
        if (existingFilterIds != null) {
            newFilterIds.addAll(existingFilterIds);
        }
        if ((newFilters = action.getFilters()) != null) {
            for (ActionFilter filter : newFilters) {
                String filterId = filter.getId();
                DefaultActionFilter f = (DefaultActionFilter)filter;
                f.setAppend(true);
                this.filters.addContribution(f);
                if (newFilterIds.contains(filterId)) continue;
                newFilterIds.add(filterId);
            }
            action.setFilters(null);
        }
        action.setFilterIds(newFilterIds);
        this.actionReg.addAction(action);
    }

    public String getContributionId(Action contrib) {
        return contrib.getId();
    }

    public void merge(Action source, Action dest) {
        ActionPropertiesDescriptor newProps;
        int newOrder;
        String type;
        String tooltip;
        String newConfirm;
        String newLink;
        String newIcon = source.getIcon();
        if (newIcon != null && !newIcon.equals(dest.getIcon())) {
            dest.setIcon(newIcon);
        }
        if (source.isEnabled() != dest.isEnabled()) {
            dest.setEnabled(source.isEnabled());
        }
        HashSet<String> mergedCategories = new HashSet<String>(Arrays.asList(dest.getCategories()));
        mergedCategories.addAll(new HashSet<String>(Arrays.asList(source.getCategories())));
        dest.setCategories(mergedCategories.toArray(new String[mergedCategories.size()]));
        String newLabel = source.getLabel();
        if (newLabel != null && !newLabel.equals(dest.getLabel())) {
            dest.setLabel(newLabel);
        }
        if ((newLink = source.getLink()) != null && !newLink.equals(dest.getLink())) {
            dest.setLink(newLink);
        }
        if ((newConfirm = source.getConfirm()) != null && !"".equals(newConfirm) && !newConfirm.equals(dest.getConfirm())) {
            dest.setConfirm(newConfirm);
        }
        if ((tooltip = source.getHelp()) != null && !tooltip.equals(dest.getHelp())) {
            dest.setHelp(tooltip);
        }
        if ((type = source.getType()) != null && !type.equals(dest.getType())) {
            dest.setType(type);
        }
        if ((newOrder = source.getOrder()) > 0 && newOrder != dest.getOrder()) {
            dest.setOrder(newOrder);
        }
        ArrayList<String> newFilterIds = new ArrayList<String>();
        newFilterIds.addAll(dest.getFilterIds());
        newFilterIds.addAll(source.getFilterIds());
        dest.setFilterIds(newFilterIds);
        ActionFilter[] existingFilters = dest.getFilters();
        ActionFilter[] newFilters = source.getFilters();
        ArrayList<ActionFilter> filters = new ArrayList<ActionFilter>();
        if (existingFilters != null) {
            filters.addAll(Arrays.asList(existingFilters));
        }
        if (newFilters != null) {
            filters.addAll(Arrays.asList(newFilters));
        }
        dest.setFilters(filters.toArray(new ActionFilter[0]));
        String newAccessKey = source.getAccessKey();
        if (newAccessKey != null && !newAccessKey.isEmpty()) {
            dest.setAccessKey(newAccessKey);
        }
        if ((newProps = source.getPropertiesDescriptor()) != null) {
            boolean append = newProps.isAppend();
            if (!append) {
                dest.setPropertiesDescriptor(newProps);
            } else {
                ActionPropertiesDescriptor oldProps = dest.getPropertiesDescriptor();
                if (oldProps != null) {
                    oldProps.merge(newProps);
                    dest.setPropertiesDescriptor(oldProps);
                } else {
                    dest.setPropertiesDescriptor(newProps);
                }
            }
        }
    }
}

