/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomKeyFactory {
    private static final Map<EncryptionType, String> DEFAULT_CIPHERS;

    public static Map<EncryptionType, EncryptionKey> getRandomKeys() throws KerberosException {
        return RandomKeyFactory.getRandomKeys(DEFAULT_CIPHERS.keySet());
    }

    public static Map<EncryptionType, EncryptionKey> getRandomKeys(Set<EncryptionType> ciphers) throws KerberosException {
        HashMap<EncryptionType, EncryptionKey> map = new HashMap<EncryptionType, EncryptionKey>();
        for (EncryptionType type : ciphers) {
            map.put(type, RandomKeyFactory.getRandomKey(type));
        }
        return map;
    }

    public static EncryptionKey getRandomKey(EncryptionType encryptionType) throws KerberosException {
        String algorithm = DEFAULT_CIPHERS.get(encryptionType);
        if (algorithm == null) {
            throw new KerberosException(ErrorType.KDC_ERR_ETYPE_NOSUPP, encryptionType.getName() + " is not a supported encryption type.");
        }
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
            if (encryptionType.equals(EncryptionType.AES128_CTS_HMAC_SHA1_96)) {
                keyGenerator.init(128);
            }
            if (encryptionType.equals(EncryptionType.AES256_CTS_HMAC_SHA1_96)) {
                keyGenerator.init(256);
            }
            SecretKey key = keyGenerator.generateKey();
            byte[] keyBytes = key.getEncoded();
            return new EncryptionKey(encryptionType, keyBytes);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KerberosException(ErrorType.KDC_ERR_ETYPE_NOSUPP, (Throwable)nsae);
        }
    }

    static {
        HashMap<EncryptionType, String> map = new HashMap<EncryptionType, String>();
        map.put(EncryptionType.DES_CBC_MD5, "DES");
        map.put(EncryptionType.DES3_CBC_SHA1_KD, "DESede");
        map.put(EncryptionType.RC4_HMAC, "RC4");
        map.put(EncryptionType.AES128_CTS_HMAC_SHA1_96, "AES");
        map.put(EncryptionType.AES256_CTS_HMAC_SHA1_96, "AES");
        DEFAULT_CIPHERS = Collections.unmodifiableMap(map);
    }
}

