/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionTypeInfo2Entry;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncryptionTypeInfo2Encoder {
    public static byte[] encode(EncryptionTypeInfo2Entry[] entries) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        aos.writeObject((Object)EncryptionTypeInfo2Encoder.encodeSequence(entries));
        aos.close();
        return baos.toByteArray();
    }

    protected static DERSequence encodeSequence(EncryptionTypeInfo2Entry[] entries) {
        DERSequence sequence = new DERSequence();
        for (int ii = 0; ii < entries.length; ++ii) {
            sequence.add((DEREncodable)EncryptionTypeInfo2Encoder.encode(entries[ii]));
        }
        return sequence;
    }

    protected static DERSequence encode(EncryptionTypeInfo2Entry entry) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)DERInteger.valueOf((int)entry.getEncryptionType().getOrdinal())));
        if (entry.getSalt() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)DERGeneralString.valueOf((String)entry.getSalt())));
        }
        if (entry.getS2kParams() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)new DEROctetString(entry.getS2kParams())));
        }
        return sequence;
    }
}

