/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.components;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosPrincipalModifier;
import org.apache.directory.server.kerberos.shared.messages.value.PrincipalName;

public class TicketModifier {
    private int ticketVersionNumber;
    private KerberosPrincipalModifier serverModifier = new KerberosPrincipalModifier();
    private KerberosPrincipal serverPrincipal;
    private EncryptedData encPart;

    public Ticket getTicket() {
        if (this.serverPrincipal == null) {
            this.serverPrincipal = this.serverModifier.getKerberosPrincipal();
        }
        return new Ticket(this.ticketVersionNumber, this.serverPrincipal, this.encPart);
    }

    public void setTicketVersionNumber(int versionNumber) {
        this.ticketVersionNumber = versionNumber;
    }

    public void setEncPart(EncryptedData part) {
        this.encPart = part;
    }

    public void setServerName(PrincipalName name) {
        this.serverModifier.setPrincipalName(name);
    }

    public void setServerRealm(String realm) {
        this.serverModifier.setRealm(realm);
    }

    public void setServerPrincipal(KerberosPrincipal serverPrincipal) {
        this.serverPrincipal = serverPrincipal;
    }
}

