/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forum.web;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.comment.web.CommentManagerActions;
import org.nuxeo.ecm.platform.comment.web.ThreadEntry;
import org.nuxeo.ecm.platform.forum.web.api.PostAction;
import org.nuxeo.ecm.platform.forum.web.api.ThreadAction;
import org.nuxeo.ecm.platform.forum.web.api.ThreadAdapter;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="threadAction")
@Scope(value=ScopeType.CONVERSATION)
public class ThreadActionBean
implements ThreadAction {
    private static final Log log = LogFactory.getLog(ThreadActionBean.class);
    private static final long serialVersionUID = -2667460487440135732L;
    protected static final String schema = "thread";
    protected static final String type = "Thread";
    protected boolean principalIsAdmin;
    @In(create=true)
    protected transient Principal currentUser;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient CommentManagerActions commentManagerActions;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected PostAction postAction;
    protected String title;
    protected String description;
    protected List<String> selectedModerators;
    protected boolean moderated;
    protected NuxeoPrincipal principal;
    protected ThreadAdapter adapter;

    @Override
    public String addThread() throws ClientException {
        DocumentModel docThread = this.getThreadModel();
        docThread = this.documentManager.createDocument(docThread);
        this.documentManager.save();
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
        this.clean();
        return this.navigationContext.navigateToDocument(docThread, "after-create");
    }

    protected void clean() {
        this.title = null;
        this.description = null;
        this.moderated = false;
        this.selectedModerators = null;
    }

    protected DocumentModel getThreadModel() throws ClientException {
        PathSegmentService pss;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        String path = currentDocument.getPathAsString();
        DocumentModel docThread = this.documentManager.createDocumentModel(type);
        docThread.setProperty("dublincore", "title", (Object)this.title);
        docThread.setProperty("dublincore", "description", (Object)this.description);
        docThread.setProperty(schema, "moderated", (Object)this.moderated);
        if (this.moderated) {
            if (!this.selectedModerators.contains("user:" + this.currentUser.getName())) {
                this.selectedModerators.add("user:" + this.currentUser.getName());
            }
            if (!this.selectedModerators.contains("group:administrators")) {
                this.selectedModerators.add("group:administrators");
            }
            if (this.selectedModerators.contains("user:Administrator")) {
                this.selectedModerators.remove("user:Administrator");
            }
            docThread.setProperty(schema, "moderators", this.selectedModerators);
        }
        try {
            pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        docThread.setPathInfo(path, pss.generatePathSegment(docThread));
        return docThread;
    }

    @Override
    public List<String> getModerators() {
        DocumentModel currentThread = this.navigationContext.getCurrentDocument();
        try {
            return (List)currentThread.getProperty(schema, "moderators");
        }
        catch (ClientException ce) {
            throw new ClientRuntimeException((Throwable)ce);
        }
    }

    @Override
    public boolean isPrincipalModerator() {
        this.principal = (NuxeoPrincipal)FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
        List<String> moderators = this.getModerators();
        boolean moderator = false;
        if (this.isPrincipalGroupModerator() || moderators != null && moderators.contains("user:" + this.principal.getName())) {
            moderator = true;
        }
        return moderator;
    }

    @Override
    public boolean isPrincipalGroupModerator() {
        List<String> moderators = this.getModerators();
        List principalGroups = this.principal.getAllGroups();
        for (String principalGroup : principalGroups) {
            if (moderators == null || !moderators.contains("group:" + principalGroup)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCurrentThreadModerated() throws ClientException {
        DocumentModel currentThread = this.navigationContext.getCurrentDocument();
        return this.isThreadModerated(currentThread);
    }

    @Override
    @Factory(value="currentThreadPosts", scope=ScopeType.EVENT)
    public List<ThreadEntry> getPostsAsThread() throws ClientException {
        ArrayList<ThreadEntry> basicCommentList = null;
        if (!this.isCurrentThreadModerated()) {
            basicCommentList = this.commentManagerActions.getCommentsAsThread();
        } else {
            basicCommentList = new ArrayList<ThreadEntry>();
            List allThreadEntry = this.commentManagerActions.getCommentsAsThread();
            for (ThreadEntry threadEntry : allThreadEntry) {
                DocumentModel dm = threadEntry.getComment();
                String[] contributorsArray = (String[])dm.getProperty("dublincore", "contributors");
                if (contributorsArray == null) {
                    contributorsArray = new String[]{};
                }
                List<String> cs = Arrays.asList(contributorsArray);
                if (!this.postAction.isPostPublished(threadEntry.getComment()) && !this.isPrincipalModerator() && !cs.contains(this.currentUser.getName())) continue;
                basicCommentList.add(threadEntry);
            }
        }
        return basicCommentList;
    }

    @Override
    public ThreadAdapter getAdapter(DocumentModel thread) {
        if (thread == null) {
            return null;
        }
        if (this.adapter != null && this.adapter.getThreadDoc().getRef().equals(thread.getRef())) {
            return this.adapter;
        }
        if (thread.getSessionId() == null) {
            try {
                thread = this.documentManager.getDocument(thread.getRef());
            }
            catch (ClientException e) {
                log.error((Object)"Unable to reconnect doc !,", (Throwable)e);
            }
        }
        this.adapter = (ThreadAdapter)thread.getAdapter(ThreadAdapter.class);
        return this.adapter;
    }

    @Override
    public List<DocumentModel> getAllPosts(DocumentModel thread, String state) throws ClientException {
        thread = this.getDocumentThreadModel(thread.getRef());
        List<DocumentModel> allPosts = Collections.emptyList();
        List allThreadEntry = Collections.emptyList();
        if (thread != null) {
            allThreadEntry = this.commentManagerActions.getCommentsAsThreadOnDoc(thread);
        }
        if (allThreadEntry != null && !allThreadEntry.isEmpty()) {
            allPosts = new ArrayList<DocumentModel>();
            for (ThreadEntry entry : allThreadEntry) {
                if (!"".equals(state) && state.equals(entry.getComment().getCurrentLifeCycleState())) {
                    allPosts.add(entry.getComment());
                    continue;
                }
                if (!"".equals(state)) continue;
                allPosts.add(entry.getComment());
            }
        }
        return allPosts;
    }

    @Override
    public List<DocumentModel> getPostsPublished(DocumentModel thread) throws ClientException {
        return this.getAllPosts(thread, "moderation_published");
    }

    @Override
    public List<DocumentModel> getPostsPending(DocumentModel thread) throws ClientException {
        return this.getAllPosts(thread, "moderation_pending");
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    public String getSchema() {
        return schema;
    }

    public String getType() {
        return type;
    }

    public void saveState() {
        log.info((Object)"PrePassivate");
    }

    public void readState() {
        log.info((Object)"PostActivate");
    }

    @Override
    public boolean isModerated() {
        return this.moderated;
    }

    @Override
    public void setModerated(boolean moderated) {
        this.moderated = moderated;
    }

    @Override
    public DocumentModel getLastPostPublished(DocumentModel thread) throws ClientException {
        thread = this.getDocumentThreadModel(thread.getRef());
        List<DocumentModel> posts = this.getPostsPublished(thread);
        DocumentModel lastPost = null;
        if (!posts.isEmpty()) {
            lastPost = posts.get(0);
            for (DocumentModel post : posts) {
                GregorianCalendar lastPostDate = (GregorianCalendar)lastPost.getProperty("post", "creationDate");
                GregorianCalendar postDate = (GregorianCalendar)post.getProperty("post", "creationDate");
                if (postDate == null || !postDate.after(lastPostDate)) continue;
                lastPost = post;
            }
        }
        return lastPost;
    }

    @Override
    public String getModerationAsString(DocumentModel thread) throws ClientException {
        if (this.isThreadModerated(thread)) {
            return (String)this.resourcesAccessor.getMessages().get("label.forum.thread.moderated.yes");
        }
        return (String)this.resourcesAccessor.getMessages().get("label.forum.thread.moderated.no");
    }

    @Override
    public boolean isThreadModerated(DocumentModel thread) throws ClientException {
        Boolean moderation;
        if (thread != null && (thread = this.getDocumentThreadModel(thread.getRef())) != null && (moderation = (Boolean)thread.getProperty(schema, "moderated")) != null) {
            return moderation;
        }
        return false;
    }

    @Override
    public DocumentModel getParentPost(int post) throws ClientException {
        DocumentModel parentPost = null;
        List<ThreadEntry> posts = this.getPostsAsThread();
        if (post > 0 && post <= posts.size()) {
            ThreadEntry parent = posts.get(post - 1);
            ThreadEntry currentPost = posts.get(post);
            if (currentPost.getDepth() == parent.getDepth() + 1) {
                parentPost = parent.getComment();
            }
        }
        return parentPost;
    }

    @Override
    public boolean isParentPostPublished(int post) throws ClientException {
        DocumentModel parent = this.getParentPost(post);
        if (parent == null) {
            return true;
        }
        return "moderation_published".equals(parent.getCurrentLifeCycleState());
    }

    protected DocumentModel getDocumentThreadModel(DocumentRef threadRef) throws ClientException {
        DocumentModel thread = null;
        if (threadRef != null) {
            thread = this.documentManager.getDocument(threadRef);
        }
        return thread;
    }

    public List<String> getSelectedModerators() {
        if (this.selectedModerators == null) {
            this.selectedModerators = new ArrayList<String>();
        }
        return this.selectedModerators;
    }

    public void setSelectedModerators(List<String> selectedModerators) {
        this.selectedModerators = selectedModerators;
    }
}

