/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.collections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ScopeType;

public class ScopedMap
extends HashMap<String, Serializable> {
    private static final Log log = LogFactory.getLog(ScopedMap.class);
    private static final long serialVersionUID = -616031057117818344L;

    public Serializable getScopedValue(ScopeType scope, String key) {
        Serializable res = null;
        if (scope != null && key != null) {
            res = (Serializable)this.get(scope.getScopedKey(key));
        }
        return res;
    }

    public Serializable getScopedValue(String key) {
        return this.getScopedValue(ScopeType.DEFAULT, key);
    }

    public Map<String, Serializable> getDefaultScopeValues() {
        return this.getScopeValues(ScopeType.DEFAULT);
    }

    public Map<String, Serializable> getScopeValues(ScopeType scopeType) {
        HashMap<String, Serializable> defMap = new HashMap<String, Serializable>();
        String defaultScopePrefix = scopeType.getScopePrefix();
        int prefixLen = defaultScopePrefix.length();
        for (Map.Entry entry : this.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(defaultScopePrefix)) continue;
            defMap.put(key.substring(prefixLen), (Serializable)entry.getValue());
        }
        return defMap;
    }

    public void putScopedValue(ScopeType scope, String key, Serializable value) {
        if (scope == null || key == null) {
            log.error((Object)String.format("Cannot set scope value using scopeType=%s and key=%s", new Object[]{scope, key}));
        } else {
            this.put(scope.getScopedKey(key), value);
        }
    }

    public void putScopedValue(String key, Serializable value) {
        this.putScopedValue(ScopeType.DEFAULT, key, value);
    }

    public void clearScope(ScopeType scopeType) {
        if (scopeType == null) {
            log.error((Object)"Cannot clear map, specified scope is null");
        } else {
            String prefix = scopeType.getScopePrefix();
            ArrayList<String> toRemove = new ArrayList<String>();
            for (Map.Entry entry : this.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith(prefix)) continue;
                toRemove.add(key);
            }
            for (String key : toRemove) {
                this.remove(key);
            }
        }
    }
}

