/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.UnsupportedEncodingException;

public class RFC2231 {
    private static final String UTF8 = "UTF-8";
    private static final byte[] UNKNOWN_BYTES = new byte[]{63};

    private RFC2231() {
    }

    public static void percentEscape(StringBuilder buf, String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            bytes = UNKNOWN_BYTES;
        }
        for (byte b : bytes) {
            if (b < 43 || b == 59 || b == 44 || b == 92 || b > 122) {
                buf.append('%');
                String s = Integer.toHexString(b & 0xFF).toUpperCase();
                if (s.length() < 2) {
                    buf.append('0');
                }
                buf.append(s);
                continue;
            }
            buf.append((char)b);
        }
    }

    public static String encodeContentDisposition(String filename, boolean inline, String userAgent) {
        StringBuilder buf = new StringBuilder(inline ? "inline; " : "attachment; ");
        if (userAgent == null) {
            userAgent = "";
        }
        if (userAgent.contains("Firefox") || userAgent.contains("Chrome")) {
            buf.append("filename*=UTF-8''");
            RFC2231.percentEscape(buf, filename);
        } else {
            buf.append("filename=");
            if (userAgent.contains("MSIE")) {
                RFC2231.percentEscape(buf, filename);
            } else {
                buf.append(filename);
            }
        }
        return buf.append(';').toString();
    }
}

