/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

public class SizeUtils {
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;

    private SizeUtils() {
    }

    public static long parseSizeInBytes(String string) throws NumberFormatException {
        long mul;
        String digits = string;
        if (digits.length() == 0) {
            throw new NumberFormatException("Invalid empty string");
        }
        char unit = digits.charAt(digits.length() - 1);
        if (unit == 'b' || unit == 'B') {
            if ((digits = digits.substring(0, digits.length() - 1)).length() == 0) {
                throw new NumberFormatException(string);
            }
            unit = digits.charAt(digits.length() - 1);
        }
        switch (unit) {
            case 'K': 
            case 'k': {
                mul = 1024L;
                break;
            }
            case 'M': 
            case 'm': {
                mul = 0x100000L;
                break;
            }
            case 'G': 
            case 'g': {
                mul = 0x40000000L;
                break;
            }
            case 'T': 
            case 't': {
                mul = 0x10000000000L;
                break;
            }
            default: {
                if (!Character.isDigit(unit)) {
                    throw new NumberFormatException(string);
                }
                mul = 1L;
            }
        }
        if (mul != 1L && (digits = digits.substring(0, digits.length() - 1)).length() == 0) {
            throw new NumberFormatException(string);
        }
        try {
            return Long.parseLong(digits.trim()) * mul;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(string);
        }
    }
}

