/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils.i18n;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class I18NUtils {
    private I18NUtils() {
    }

    static ClassLoader getCurrentClassLoader(Object defaultObject) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = defaultObject.getClass().getClassLoader();
        }
        return loader;
    }

    public static String getMessageString(String bundleName, String key, Object[] params, Locale locale) {
        String text;
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, I18NUtils.getCurrentClassLoader(params));
        try {
            text = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            text = key;
        }
        if (params != null) {
            MessageFormat mf = new MessageFormat(text, locale);
            text = mf.format(params, new StringBuffer(), (FieldPosition)null).toString();
        }
        return text;
    }
}

