/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.http.client;

import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.http.client.authentication.PortalSSOAuthenticationProvider;
import org.restlet.Client;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.resource.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NuxeoServer {
    public static final int AUTH_TYPE_NONE = 0;
    public static final int AUTH_TYPE_BASIC = 1;
    public static final int AUTH_TYPE_SECRET = 2;
    protected String baseURL = "http://127.0.0.1:8080/nuxeo";
    protected String restPrefix = "restAPI";
    protected String davPrefix = "dav";
    protected int authType = 0;
    protected String userName;
    protected String password;
    protected String secretToken;
    protected Client restClient;

    public NuxeoServer(String baseURL) {
        this.baseURL = baseURL;
    }

    public NuxeoServer(String protocol, String serverIP, String serverPort) {
        this(protocol, serverIP, serverPort, "nuxeo");
    }

    public NuxeoServer(String protocol, String serverIP, String serverPort, String servletPath) {
        StringBuffer sb = new StringBuffer();
        sb.append(protocol);
        sb.append("://");
        sb.append(serverIP);
        if (serverPort != null && !serverIP.equals("80")) {
            sb.append(':');
            sb.append(serverPort);
        }
        sb.append(servletPath);
        sb.append('/');
        this.baseURL = sb.toString();
    }

    public void setBasicAuthentication(String userName, String password) {
        this.authType = 1;
        this.userName = userName;
        this.password = password;
    }

    public void setSharedSecretAuthentication(String userName, String secretToken) {
        this.authType = 2;
        this.userName = userName;
        this.secretToken = secretToken;
    }

    public Representation doRestletGetCall(List<String> pathParams, Map<String, String> queryParams) {
        String path = "";
        StringBuffer pathBuffer = new StringBuffer();
        if (pathParams != null) {
            for (String p : pathParams) {
                pathBuffer.append(p);
                pathBuffer.append('/');
            }
            path = pathBuffer.toString();
        }
        return this.doRestletGetCall(path, queryParams);
    }

    public Representation doRestletGetCall(String subPath, Map<String, String> queryParams) {
        StringBuffer urlBuffer = new StringBuffer();
        if (subPath.startsWith("/")) {
            subPath = subPath.substring(1);
        }
        if (subPath.endsWith("/")) {
            subPath = subPath.substring(0, subPath.length() - 1);
        }
        urlBuffer.append(this.baseURL);
        urlBuffer.append('/');
        urlBuffer.append(this.restPrefix);
        urlBuffer.append('/');
        urlBuffer.append(subPath);
        if (queryParams != null) {
            urlBuffer.append('?');
            for (String qpName : queryParams.keySet()) {
                urlBuffer.append(qpName);
                urlBuffer.append('=');
                urlBuffer.append(queryParams.get(qpName).replaceAll(" ", "%20"));
                urlBuffer.append('&');
            }
        }
        String completeURL = urlBuffer.toString();
        Request request = new Request(Method.GET, completeURL);
        this.setupAuth(request);
        return this.getRestClient().handle(request).getEntity();
    }

    protected void setupAuth(Request request) {
        if (this.authType == 1) {
            ChallengeScheme scheme = ChallengeScheme.HTTP_BASIC;
            ChallengeResponse authentication = new ChallengeResponse(scheme, this.userName, this.password);
            request.setChallengeResponse(authentication);
        } else if (this.authType == 2) {
            Form additionnalHeaders = new Form();
            Map<String, String> securityHeaders = PortalSSOAuthenticationProvider.getHeaders(this.secretToken, this.userName);
            for (String hn : securityHeaders.keySet()) {
                additionnalHeaders.add(hn, securityHeaders.get(hn));
            }
            request.getAttributes().put("org.restlet.http.headers", additionnalHeaders);
        }
    }

    protected Client getRestClient() {
        if (this.restClient == null) {
            this.restClient = this.baseURL.startsWith("https") ? new Client(Protocol.HTTPS) : new Client(Protocol.HTTP);
        }
        return this.restClient;
    }

    public int getAuthType() {
        return this.authType;
    }

    public void setAuthType(int authType) {
        this.authType = authType;
    }

    public String getDavPrefix() {
        return this.davPrefix;
    }

    public void setDavPrefix(String davPrefix) {
        this.davPrefix = davPrefix;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRestPrefix() {
        return this.restPrefix;
    }

    public void setRestPrefix(String restPrefix) {
        this.restPrefix = restPrefix;
    }

    public String getSecretToken() {
        return this.secretToken;
    }

    public void setSecretToken(String secretToken) {
        this.secretToken = secretToken;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

