/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jboss.deployer.structure;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.virtual.VirtualFile;
import org.nuxeo.runtime.jboss.deployer.Utils;
import org.nuxeo.runtime.jboss.deployer.structure.PathMatcher;

public class DeploymentStructure {
    protected Map<String, String> properties = new HashMap<String, String>();
    protected String[] resolvedBundlePaths;
    protected final VirtualFile vhome;
    protected File home;
    protected String[] bundles;
    protected String[] children;
    protected final List<Context> ctxs = new ArrayList<Context>();
    protected boolean requirePreprocessing = true;
    protected String[] preprocessorClassPath;

    public DeploymentStructure(VirtualFile vhome) {
        this.vhome = vhome;
    }

    public void initialize(long lastModified) throws Exception {
        this.home = Utils.getRealHomeDir(this.vhome, lastModified).getCanonicalFile();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key, String defValue) {
        String v = this.properties.get(key);
        return v == null ? defValue : v;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String expandProperty(String key, String defaultValue) {
        String v = this.properties.get(key);
        if (v != null) {
            return Utils.expandVars(v, System.getProperties());
        }
        return defaultValue;
    }

    public void addContext(Context ctx) {
        this.ctxs.add(ctx);
    }

    public List<Context> getContexts() {
        return this.ctxs;
    }

    protected String[] resolveBundles() throws IOException {
        String[] bp = this.getBundles();
        if (bp == null || bp.length == 0) {
            return null;
        }
        PathMatcher matcher = new PathMatcher();
        matcher.addPatterns(bp);
        List<String> list = matcher.getMatchesAsPaths(this.getHome());
        this.resolvedBundlePaths = list.toArray(new String[list.size()]);
        Arrays.sort(this.resolvedBundlePaths);
        return this.resolvedBundlePaths;
    }

    public String[] getResolvedBundles() throws IOException {
        if (this.resolvedBundlePaths == null) {
            this.resolveBundles();
        }
        return this.resolvedBundlePaths;
    }

    public File[] getResolvedBundleFiles() throws IOException {
        if (this.getResolvedBundles() == null) {
            throw new IllegalStateException("You must call this method only after bundles are resolved");
        }
        File[] files = new File[this.resolvedBundlePaths.length];
        for (int i = 0; i < this.resolvedBundlePaths.length; ++i) {
            files[i] = new File(this.home, this.resolvedBundlePaths[i]);
        }
        return files;
    }

    public File getHome() {
        if (this.home == null) {
            throw new IllegalStateException("The initialize method must be called before using the deployment structure object.");
        }
        return this.home;
    }

    public VirtualFile getVirtualHome() {
        return this.vhome;
    }

    public void setBundles(String ... bundles) {
        this.bundles = bundles;
    }

    public String[] getBundles() {
        return this.bundles;
    }

    public void setRequirePreprocessing(boolean requirePreprocessing) {
        this.requirePreprocessing = requirePreprocessing;
    }

    public void setPreprocessorClassPath(String[] preprocessorClassPath) {
        this.preprocessorClassPath = preprocessorClassPath;
    }

    public String[] getPreprocessorClassPath() {
        return this.preprocessorClassPath;
    }

    public boolean isRequirePreprocessing() {
        return this.requirePreprocessing;
    }

    public void setChildren(String ... children) {
        this.children = children;
    }

    public String[] getChildren() {
        return this.children;
    }

    public static class Context {
        protected final String path;
        protected String[] classpath;
        protected String[] metaDataPath;

        public Context(String path) {
            this.path = path == null ? "" : path;
        }

        public String getPath() {
            return this.path;
        }

        public void setClasspath(String ... classpath) {
            this.classpath = classpath;
        }

        public String[] getClasspath() {
            return this.classpath;
        }

        public void setMetaDataPath(String ... metaDataPath) {
            this.metaDataPath = metaDataPath;
        }

        public String[] getMetaDataPath() {
            return this.metaDataPath;
        }
    }
}

