/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.bank;

import java.io.IOException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.Access;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.theme.bank.ThemeBankException;
import org.nuxeo.theme.resources.BankManager;

@WebObject(type="Management", administrator=Access.GRANT)
@Produces(value={"text/html"})
public class Management
extends DefaultObject {
    private static final Log log = LogFactory.getLog(Management.class);
    String bank;

    protected void initialize(Object ... args) {
        assert (args != null && args.length > 0);
        this.bank = (String)args[0];
    }

    @POST
    @Path(value="upload")
    public Object uploadFile() {
        FormData form = this.ctx.getForm();
        String collection = form.getString("collection");
        String redirectUrl = form.getString("redirect_url");
        FileItem fileItem = form.getFileItem("file");
        if (!fileItem.isFormField()) {
            byte[] fileData = fileItem.get();
            String filename = fileItem.getName();
            String path = String.format("%s/%s/image", this.bank, collection);
            try {
                BankManager.createFile((String)path, (String)filename, (byte[])fileData);
            }
            catch (IOException e) {
                throw new ThemeBankException(e.getMessage(), e);
            }
        }
        if (redirectUrl != null) {
            return this.redirect(redirectUrl);
        }
        return null;
    }

    @POST
    @Path(value="saveCss")
    public Object saveCss() {
        FormData form = this.ctx.getForm();
        String css = form.getString("css");
        String collection = form.getString("collection");
        String resource = form.getString("resource");
        String path = String.format("%s/%s/style", this.bank, collection);
        try {
            BankManager.editFile((String)path, (String)resource, (String)css);
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
        String redirectUrl = form.getString("redirect_url");
        return this.redirect(redirectUrl);
    }

    @POST
    @Path(value="{collection}/createStyle")
    public Object createStyle(@PathParam(value="collection") String collection) {
        FormData form = this.ctx.getForm();
        String resource = form.getString("resource");
        String path = String.format("%s/%s/style", this.bank, collection);
        String fileName = String.format("%s.css", resource);
        try {
            BankManager.createFile((String)path, (String)fileName, (String)"");
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
        String redirectUrl = form.getString("redirect_url");
        return this.redirect(redirectUrl);
    }

    @POST
    @Path(value="{collection}/download")
    public Response downloadCollection(@PathParam(value="collection") String collection) {
        byte[] data;
        try {
            data = BankManager.exportBankData((String)this.bank, (String)collection);
        }
        catch (IOException e) {
            throw new ThemeBankException(e.getMessage(), e);
        }
        String filename = String.format("%s.zip", collection.replace(" ", "-"));
        Response.ResponseBuilder builder = Response.ok((Object)data);
        builder.header("Content-disposition", (Object)String.format("attachment; filename=%s", filename));
        builder.type("application/zip");
        return builder.build();
    }
}

