/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.editor.views;

import java.util.Properties;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.rendering.RenderingInfo;

public class AreaStyleToolbox {
    public static String render(RenderingInfo info) {
        Style style = (Style)ElementFormatter.getFormatFor((Element)info.getElement(), (String)"style");
        Properties properties = null;
        if (style != null) {
            String viewName = info.getFormat().getName();
            properties = style.getPropertiesFor(viewName, "");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"toolbox\">");
        sb.append(AreaStyleToolbox.renderIcon(properties, "background", "background", "area-style-background.png"));
        sb.append(AreaStyleToolbox.renderIcon(properties, "border-left", "left border", "area-style-border-left.png"));
        sb.append(AreaStyleToolbox.renderIcon(properties, "border-top", "top border", "area-style-border-top.png"));
        sb.append(AreaStyleToolbox.renderIcon(properties, "border-bottom", "bottom border", "area-style-border-bottom.png"));
        sb.append(AreaStyleToolbox.renderIcon(properties, "border-right", "right border", "area-style-border-right.png"));
        sb.append("</div>");
        return sb.toString();
    }

    private static String renderIcon(Properties properties, String name, String title, String image) {
        String className = "picker";
        if (properties != null && properties.getProperty(name) != null) {
            className = "picker selected";
        }
        return String.format("<img class=\"%s\" name=\"%s\" width=\"16\" height=\"16\" title=\"%s\" src=\"/nuxeo/nxthemes/editor/img/%s\" />", className, name, title, image);
    }
}

