/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.editor.managers;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.Stateless;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.SerializedConcurrentAccess;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.theme.ApplicationType;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.NegotiationDef;
import org.nuxeo.theme.editor.managers.UiManagerLocal;
import org.nuxeo.theme.editor.previews.Preview;
import org.nuxeo.theme.editor.states.UiStatesLocal;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.elements.ElementType;
import org.nuxeo.theme.elements.PageElement;
import org.nuxeo.theme.elements.ThemeElement;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.FormatType;
import org.nuxeo.theme.formats.layouts.Layout;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.formats.widgets.Widget;
import org.nuxeo.theme.fragments.Fragment;
import org.nuxeo.theme.fragments.FragmentType;
import org.nuxeo.theme.html.Utils;
import org.nuxeo.theme.jsf.negotiation.CookieManager;
import org.nuxeo.theme.models.ModelType;
import org.nuxeo.theme.perspectives.PerspectiveManager;
import org.nuxeo.theme.perspectives.PerspectiveType;
import org.nuxeo.theme.presets.PresetType;
import org.nuxeo.theme.properties.FieldIO;
import org.nuxeo.theme.properties.FieldInfo;
import org.nuxeo.theme.themes.ThemeDescriptor;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.types.TypeRegistry;
import org.nuxeo.theme.uids.Identifiable;
import org.nuxeo.theme.views.ViewType;
import org.nuxeo.theme.vocabularies.VocabularyItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Name(value="nxthemesUiManager")
@Scope(value=ScopeType.SESSION)
@SerializedConcurrentAccess
public class UiManager
implements UiManagerLocal {
    private static final Log log = LogFactory.getLog(UiManager.class);
    private static final String PREVIEW_PROPERTIES_RESOURCE = "/nxthemes/editor/styles/previews.properties";
    private static final boolean RESOLVE_PRESETS = false;
    private static final boolean IGNORE_VIEW_NAME = true;
    private static final boolean IGNORE_CLASSNAME = true;
    private static final boolean INDENT = true;
    private static final Pattern cssChoicePattern = Pattern.compile("\\[(.*?)\\]");
    private static final Pattern cssCategoryPattern = Pattern.compile("<(.*?)>");
    private final Properties previewProperties = new Properties();
    @In(value="nxthemesUiStates", create=true)
    public UiStatesLocal uiStates;
    private static final ThemeManager themeManager = Manager.getThemeManager();

    @Override
    public String getCurrentPagePath() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        String pagePath = CookieManager.getCookie((String)"nxthemes.theme", (ExternalContext)externalContext);
        if (pagePath == null) {
            pagePath = String.format("%s/default", this.getDefaultTheme());
        }
        return pagePath;
    }

    @Override
    public String getCurrentThemeName() {
        return this.getCurrentPagePath().split("/")[0];
    }

    @Override
    public String startEditor() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
        String referrer = request.getHeader("referer");
        if (referrer == null) {
            log.error((Object)"No referrer found, cannot start the theme editor.");
            return null;
        }
        HttpServletResponse response = (HttpServletResponse)externalContext.getResponse();
        Map requestMap = externalContext.getRequestMap();
        URL themeUrl = (URL)requestMap.get("org.nuxeo.theme.url");
        String pagePath = themeManager.getPagePathByUrl(themeUrl);
        if (pagePath != null) {
            CookieManager.setCookie((String)"nxthemes.theme", (String)pagePath, (ExternalContext)externalContext);
        }
        CookieManager.setCookie((String)"nxthemes.engine", (String)"editor", (ExternalContext)externalContext);
        try {
            response.sendRedirect(referrer);
        }
        catch (IOException e) {
            CookieManager.expireCookie((String)"nxthemes.engine", (ExternalContext)externalContext);
            log.error((Object)"Redirection failed while attempting to start the theme editor.");
        }
        return null;
    }

    @Override
    public List<FragmentInfo> getAvailableFragments() {
        ArrayList<FragmentInfo> fragments = new ArrayList<FragmentInfo>();
        List fragmentTypes = Manager.getTypeRegistry().getTypes(TypeFamily.FRAGMENT);
        String templateEngine = this.getTemplateEngine();
        for (Type f : fragmentTypes) {
            FragmentType fragmentType = (FragmentType)f;
            FragmentInfo fragmentInfo = new FragmentInfo(fragmentType);
            for (ViewType viewType : this.getViewTypesForFragmentType(fragmentType)) {
                String viewTemplateEngine = viewType.getTemplateEngine();
                if ("*".equals(viewType.getViewName()) || !templateEngine.equals(viewTemplateEngine)) continue;
                fragmentInfo.addView(viewType);
            }
            if (fragmentInfo.size() <= 0) continue;
            fragments.add(fragmentInfo);
        }
        return fragments;
    }

    public final List<ViewType> getViewTypesForFragmentType(FragmentType fragmentType) {
        ArrayList<ViewType> viewTypes = new ArrayList<ViewType>();
        for (Type v : Manager.getTypeRegistry().getTypes(TypeFamily.VIEW)) {
            ViewType viewType = (ViewType)v;
            ElementType elementType = viewType.getElementType();
            if (elementType != null && !elementType.getTypeName().equals("fragment") || !viewType.getFormatType().getTypeName().equals("widget")) continue;
            ModelType modelType = viewType.getModelType();
            if (fragmentType.getModelType() != modelType) continue;
            viewTypes.add(viewType);
        }
        return viewTypes;
    }

    @Override
    public List<SelectItem> getAvailablePerspectives() {
        ArrayList<SelectItem> selectItemList = new ArrayList<SelectItem>();
        for (PerspectiveType perspectiveType : PerspectiveManager.listPerspectives()) {
            selectItemList.add(new SelectItem((Object)perspectiveType.name, perspectiveType.title));
        }
        return selectItemList;
    }

    @Override
    public List<String> getPerspectivesOfSelectedElement() {
        ArrayList<String> perspectives = new ArrayList<String>();
        Element selectedElement = this.uiStates.getSelectedElement();
        for (PerspectiveType perspectiveType : Manager.getPerspectiveManager().getPerspectivesFor(selectedElement)) {
            perspectives.add(perspectiveType.name);
        }
        return perspectives;
    }

    @Override
    public boolean isSelectedElementAlwaysVisible() {
        Element selectedElement = this.uiStates.getSelectedElement();
        return Manager.getPerspectiveManager().isAlwaysVisible(selectedElement);
    }

    @Override
    public List<ThemeDescriptor> getThemesDescriptors() {
        ThemeDescriptor themeDescriptor;
        ArrayList<ThemeDescriptor> themeDescriptors = new ArrayList<ThemeDescriptor>();
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        Set themeNames = Manager.getThemeManager().getThemeNames();
        for (Type type : typeRegistry.getTypes(TypeFamily.THEME)) {
            if (type == null) continue;
            themeDescriptor = (ThemeDescriptor)type;
            themeDescriptors.add(themeDescriptor);
            themeNames.remove(themeDescriptor.getName());
        }
        for (String themeName : themeNames) {
            themeDescriptor = new ThemeDescriptor();
            themeDescriptor.setName(themeName);
            themeDescriptors.add(themeDescriptor);
        }
        return themeDescriptors;
    }

    @Override
    public List<ThemeInfo> getAvailableThemes() {
        ArrayList<ThemeInfo> themes = new ArrayList<ThemeInfo>();
        String defaultThemeName = this.getDefaultTheme();
        String defaultPageName = defaultThemeName.split("/")[1];
        ThemeManager themeManager = Manager.getThemeManager();
        String currentPagePath = this.getCurrentPagePath();
        String currentThemeName = currentPagePath.split("/")[0];
        for (String themeName : themeManager.getThemeNames()) {
            String className;
            String link = String.format("%s/%s", themeName, defaultPageName);
            String string = className = themeName.equals(currentThemeName) ? "selected" : "";
            if (link.equals(defaultThemeName)) {
                className = className + " default";
            }
            themes.add(new ThemeInfo(themeName, link, className));
        }
        return themes;
    }

    @Override
    public List<PageInfo> getAvailablePages() {
        String defaultThemeName = this.getDefaultTheme();
        String defaultPageName = defaultThemeName.split("/")[1];
        ArrayList<PageInfo> availablePages = new ArrayList<PageInfo>();
        String currentPagePath = this.getCurrentPagePath();
        String currentThemeName = currentPagePath.split("/")[0];
        String currentPageName = currentPagePath.split("/")[1];
        ThemeElement currentTheme = themeManager.getThemeByName(currentThemeName);
        for (PageElement page : ThemeManager.getPagesOf((ThemeElement)currentTheme)) {
            String className;
            String pageName = page.getName();
            String link = String.format("%s/%s", currentThemeName, pageName);
            String string = className = pageName.equals(currentPageName) ? "selected" : "";
            if (defaultPageName.equals(pageName)) {
                className = className + " default";
            }
            availablePages.add(new PageInfo(pageName, link, className));
        }
        return availablePages;
    }

    @Override
    public List<FieldProperty> getElementProperties() {
        Properties properties;
        Element selectedElement = this.uiStates.getSelectedElement();
        ArrayList<FieldProperty> fieldProperties = new ArrayList<FieldProperty>();
        if (selectedElement == null) {
            return fieldProperties;
        }
        try {
            properties = FieldIO.dumpFieldsToProperties((Object)selectedElement);
        }
        catch (Exception e) {
            return fieldProperties;
        }
        if (properties == null) {
            return fieldProperties;
        }
        Class<?> c = selectedElement.getClass();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = properties.getProperty(name);
            fieldProperties.add(new FieldProperty(name, value.trim(), UiManager.getFieldInfo(c, name)));
        }
        return fieldProperties;
    }

    @Override
    public List<SelectItem> getAvailablePresetGroupsForSelectedCategory() {
        ArrayList<SelectItem> groups = new ArrayList<SelectItem>();
        String category = this.uiStates.getStyleCategory();
        groups.add(new SelectItem((Object)"", ""));
        if (category == null) {
            return groups;
        }
        HashSet<String> groupNames = new HashSet<String>();
        for (Type type : Manager.getTypeRegistry().getTypes(TypeFamily.PRESET)) {
            PresetType preset = (PresetType)type;
            String group = preset.getGroup();
            if (!preset.getCategory().equals(category)) continue;
            if (!groupNames.contains(group)) {
                groups.add(new SelectItem((Object)group, group));
            }
            groupNames.add(group);
        }
        return groups;
    }

    @Override
    public List<PresetInfo> getPresetsForCurrentGroup() {
        String category = this.uiStates.getStyleCategory();
        String group = this.uiStates.getPresetGroup();
        ArrayList<PresetInfo> presets = new ArrayList<PresetInfo>();
        for (Type type : Manager.getTypeRegistry().getTypes(TypeFamily.PRESET)) {
            PresetType preset = (PresetType)type;
            if (!preset.getCategory().equals(category) || !preset.getGroup().equals(group)) continue;
            presets.add(new PresetInfo(preset));
        }
        return presets;
    }

    @Override
    public List<StyleFieldProperty> getElementStyleProperties() {
        Style style = this.getStyleOfSelectedElement();
        Style currentStyleLayer = this.uiStates.getCurrentStyleLayer();
        if (currentStyleLayer != null) {
            style = currentStyleLayer;
        }
        ArrayList<StyleFieldProperty> fieldProperties = new ArrayList<StyleFieldProperty>();
        if (style == null) {
            return fieldProperties;
        }
        String path = this.uiStates.getCurrentStyleSelector();
        if (path == null) {
            return fieldProperties;
        }
        String viewName = this.getCurrentViewName();
        if (style.getName() != null) {
            viewName = "*";
        }
        Properties properties = style.getPropertiesFor(viewName, path);
        String selectedCategory = this.uiStates.getStylePropertyCategory();
        Properties cssProperties = Utils.getCssProperties();
        Enumeration<?> propertyNames = cssProperties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            Matcher categoryMatcher;
            String name = (String)propertyNames.nextElement();
            String value = properties == null ? "" : properties.getProperty(name, "");
            String type = cssProperties.getProperty(name);
            if (!selectedCategory.equals("") && (!(categoryMatcher = cssCategoryPattern.matcher(type)).find() || !categoryMatcher.group(1).equals(selectedCategory))) continue;
            fieldProperties.add(new StyleFieldProperty(name, value, type));
        }
        return fieldProperties;
    }

    @Override
    public String getRenderedElementStyleProperties() {
        Style style = this.getStyleOfSelectedElement();
        Style currentStyleLayer = this.uiStates.getCurrentStyleLayer();
        if (currentStyleLayer != null) {
            style = currentStyleLayer;
        }
        if (style == null) {
            return "";
        }
        ArrayList<String> viewNames = new ArrayList<String>();
        String viewName = this.getCurrentViewName();
        if (style.getName() != null) {
            viewName = "*";
        }
        viewNames.add(viewName);
        return Utils.styleToCss((Style)style, viewNames, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
    }

    private static FieldInfo getFieldInfo(Class<?> c, String name) {
        try {
            return c.getField(name).getAnnotation(FieldInfo.class);
        }
        catch (Exception e) {
            log.error((Object)"Could not get field information", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<SelectItem> getAvailableViewNamesForSelectedElement() {
        ArrayList<SelectItem> selectItemList = new ArrayList<SelectItem>();
        Element selectedElement = this.uiStates.getSelectedElement();
        if (!selectedElement.getElementType().getTypeName().equals("fragment")) {
            return selectItemList;
        }
        String templateEngine = this.getTemplateEngine();
        FragmentType fragmentType = ((Fragment)selectedElement).getFragmentType();
        for (ViewType viewType : this.getViewTypesForFragmentType(fragmentType)) {
            String viewName = viewType.getViewName();
            String viewTemplateEngine = viewType.getTemplateEngine();
            if ("*".equals(viewName) || !templateEngine.equals(viewTemplateEngine)) continue;
            selectItemList.add(new SelectItem((Object)viewName, viewName));
        }
        return selectItemList;
    }

    @Override
    public Style getStyleOfSelectedElement() {
        Element selectedElement = this.uiStates.getSelectedElement();
        FormatType styleType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "style");
        return (Style)ElementFormatter.getFormatByType((Object)selectedElement, (FormatType)styleType);
    }

    @Override
    public List<SelectItem> getAvailableStyleSelectorsForSelectedElement() {
        ArrayList<SelectItem> selectItemList = new ArrayList<SelectItem>();
        Style style = this.getStyleOfSelectedElement();
        Style currentStyleLayer = this.uiStates.getCurrentStyleLayer();
        if (currentStyleLayer != null) {
            style = currentStyleLayer;
        }
        String viewName = this.getCurrentViewName();
        if (style != null) {
            if (style.getName() != null) {
                viewName = "*";
            }
            Set paths = style.getPathsForView(viewName);
            String current = this.uiStates.getCurrentStyleSelector();
            if (current != null && !paths.contains(current)) {
                selectItemList.add(new SelectItem((Object)current, current));
            }
            for (String path : paths) {
                selectItemList.add(new SelectItem((Object)path, path));
            }
        }
        return selectItemList;
    }

    @Override
    public List<SelectItem> getAvailableStyleProperties() {
        ArrayList<SelectItem> selectItemList = new ArrayList<SelectItem>();
        Properties properties = Utils.getCssProperties();
        if (properties.isEmpty()) {
            return selectItemList;
        }
        TreeSet<Object> sortedKeys = new TreeSet<Object>();
        sortedKeys.addAll(properties.keySet());
        for (Object e : sortedKeys) {
            String name = (String)e;
            selectItemList.add(new SelectItem((Object)name, name));
        }
        return selectItemList;
    }

    @Override
    public List<SelectItem> getAvailableNamedStyles() {
        ArrayList<SelectItem> selectItemList = new ArrayList<SelectItem>();
        String currentPagePath = this.getCurrentPagePath();
        String currentThemeName = currentPagePath.split("/")[0];
        List namedStyles = themeManager.getNamedObjects(currentThemeName, "style");
        if (!namedStyles.isEmpty()) {
            selectItemList.add(new SelectItem((Object)""));
            for (Identifiable namedStyle : namedStyles) {
                String value = namedStyle.getName();
                selectItemList.add(new SelectItem((Object)value));
            }
        }
        return selectItemList;
    }

    @Override
    public String getInheritedStyleNameOfSelectedElement() {
        Style style = this.getStyleOfSelectedElement();
        Style ancestor = (Style)ThemeManager.getAncestorFormatOf((Format)style);
        if (ancestor != null) {
            return ancestor.getName();
        }
        return "";
    }

    private Properties getPreviewProperties() {
        Utils.loadProperties((Properties)this.previewProperties, (String)PREVIEW_PROPERTIES_RESOURCE);
        return this.previewProperties;
    }

    @Override
    public List<StyleCategory> getStyleCategories() {
        LinkedHashMap<String, StyleCategory> categories = new LinkedHashMap<String, StyleCategory>();
        Properties cssProperties = Utils.getCssProperties();
        Enumeration<Object> elements = cssProperties.elements();
        String selectedStyleCategory = this.uiStates.getStylePropertyCategory();
        categories.put("", new StyleCategory("", "all", selectedStyleCategory.equals("")));
        while (elements.hasMoreElements()) {
            String element = (String)elements.nextElement();
            Matcher categoryMatcher = cssCategoryPattern.matcher(element);
            if (!categoryMatcher.find()) continue;
            String value = categoryMatcher.group(1);
            boolean selected = value.equals(selectedStyleCategory);
            categories.put(value, new StyleCategory(value, value, selected));
        }
        return new ArrayList<StyleCategory>(categories.values());
    }

    @Override
    public Widget getWidgetOfSelectedElement() {
        Element selectedElement = this.uiStates.getSelectedElement();
        FormatType widgetType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "widget");
        return (Widget)ElementFormatter.getFormatByType((Object)selectedElement, (FormatType)widgetType);
    }

    @Override
    public List<StyleLayer> getStyleLayersOfSelectedElement() {
        Style style = this.getStyleOfSelectedElement();
        Style currentStyleLayer = this.uiStates.getCurrentStyleLayer();
        ArrayList<StyleLayer> layers = new ArrayList<StyleLayer>();
        layers.add(new StyleLayer("This style", style.getUid(), style == currentStyleLayer || currentStyleLayer == null));
        for (Format ancestor : ThemeManager.listAncestorFormatsOf((Format)style)) {
            layers.add(1, new StyleLayer(ancestor.getName(), ancestor.getUid(), ancestor == currentStyleLayer));
        }
        return layers;
    }

    @Override
    public String getCurrentViewName() {
        return this.getWidgetOfSelectedElement().getName();
    }

    @Override
    public PaddingInfo getPaddingOfSelectedElement() {
        Element element = this.uiStates.getSelectedElement();
        String top = "";
        String bottom = "";
        String left = "";
        String right = "";
        if (element != null) {
            Layout layout = (Layout)ElementFormatter.getFormatFor((Element)element, (String)"layout");
            top = layout.getProperty("padding-top");
            bottom = layout.getProperty("padding-bottom");
            left = layout.getProperty("padding-left");
            right = layout.getProperty("padding-right");
        }
        return new PaddingInfo(top, bottom, left, right);
    }

    private static String getApplicationPath() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return "/nuxeo";
        }
        String applicationPath = (String)facesContext.getExternalContext().getRequestParameterMap().get("org.nuxeo.theme.application.path");
        if (applicationPath == null) {
            return facesContext.getExternalContext().getRequestContextPath();
        }
        return applicationPath;
    }

    private String getDefaultTheme() {
        NegotiationDef negotiation;
        String applicationPath;
        String defaultTheme = "";
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        ApplicationType application = (ApplicationType)typeRegistry.lookup(TypeFamily.APPLICATION, applicationPath = UiManager.getApplicationPath());
        if (application != null && (negotiation = application.getNegotiation()) != null) {
            defaultTheme = negotiation.getDefaultTheme();
        }
        return defaultTheme;
    }

    private String getTemplateEngine() {
        TypeRegistry typeRegistry = Manager.getTypeRegistry();
        String applicationPath = UiManager.getApplicationPath();
        if (applicationPath == null) {
            return ThemeManager.getDefaultTemplateEngineName();
        }
        ApplicationType application = (ApplicationType)typeRegistry.lookup(TypeFamily.APPLICATION, applicationPath);
        if (application != null) {
            return application.getTemplateEngine();
        }
        return ThemeManager.getDefaultTemplateEngineName();
    }

    public class PaddingInfo {
        private final String top;
        private final String bottom;
        private final String left;
        private final String right;

        public PaddingInfo(String top, String bottom, String left, String right) {
            this.top = top;
            this.bottom = bottom;
            this.left = left;
            this.right = right;
        }

        public String getBottom() {
            return this.bottom;
        }

        public String getLeft() {
            return this.left;
        }

        public String getRight() {
            return this.right;
        }

        public String getTop() {
            return this.top;
        }
    }

    public class StyleLayer {
        private final String name;
        private final Integer uid;
        private final boolean selected;

        public StyleLayer(String name, Integer uid, boolean selected) {
            this.name = name;
            this.uid = uid;
            this.selected = selected;
        }

        public String getRendered() {
            String className = this.selected ? "selected" : "";
            return String.format("<a href=\"javascript:void(0)\" class=\"%s\" onclick=\"NXThemesStyleEditor.setCurrentStyleLayer(%s)\" >%s</a>", className, this.uid, this.name);
        }
    }

    public class StyleCategory {
        private final String category;
        private final String title;
        private final boolean selected;

        public StyleCategory(String category, String title, boolean selected) {
            this.category = category;
            this.title = title;
            this.selected = selected;
        }

        public String getCategory() {
            return this.category;
        }

        public String getRendered() {
            String className = this.selected ? "selected" : "";
            return String.format("<a href=\"javascript:void(0)\" class=\"%s\" onclick=\"NXThemesStyleEditor.setStylePropertyCategory('%s')\">%s</a>\n", className, this.category, this.title);
        }
    }

    public class PresetInfo {
        final PresetType preset;

        public PresetInfo(PresetType preset) {
            this.preset = preset;
        }

        public String getName() {
            return this.preset.getTypeName();
        }

        public String getPreview() {
            String category = this.preset.getCategory();
            String previewClassName = UiManager.this.getPreviewProperties().getProperty(category);
            if (previewClassName == null) {
                return "";
            }
            Preview preview = null;
            try {
                preview = (Preview)Class.forName(previewClassName).newInstance();
            }
            catch (Exception e) {
                log.error((Object)"Could not get preview", (Throwable)e);
            }
            if (preview == null) {
                return "";
            }
            String content = this.preset.getName();
            return preview.render(this.preset.getValue(), content);
        }
    }

    public class StyleFieldProperty {
        private final String name;
        private final String value;
        private final String type;

        public StyleFieldProperty(String name, String value, String type) {
            this.name = name;
            this.value = value.replace("\"", "&quot;");
            this.type = type;
        }

        public String getName() {
            return String.format("&quot;%s&quot;", this.name);
        }

        public String getValue() {
            return this.value;
        }

        public String getRendered() {
            StringBuilder rendered = new StringBuilder();
            String label = this.name;
            rendered.append("<label>").append(label).append("</label>");
            Matcher choiceMatcher = cssChoicePattern.matcher(this.type);
            Matcher categoryMatcher = cssCategoryPattern.matcher(this.type);
            boolean hasChoices = choiceMatcher.find();
            boolean hasCategory = categoryMatcher.find();
            if (hasChoices) {
                String choices = choiceMatcher.group(1);
                rendered.append(String.format("<select name=\"property:%s\">", this.name));
                rendered.append("<option></option>");
                for (String choice : choices.split("\\|")) {
                    rendered.append(String.format("<option%s>%s</option>", choice.equals(this.value) ? " selected=\"selected\"" : "", choice));
                }
                rendered.append("</select>");
            } else {
                String input = String.format("<input type=\"text\" class=\"textInput\" name=\"property:%s\" value=\"%s\" />", this.name, this.value);
                rendered.append(input);
            }
            if (hasCategory) {
                String category = categoryMatcher.group(1);
                rendered.append(String.format("<input type=\"button\" class=\"picker\" property=\"%s\" category=\"%s\" value=\"\" />", this.name, category));
            }
            return rendered.toString();
        }
    }

    public static class FieldProperty {
        private final String name;
        private final String value;
        private final FieldInfo info;

        public FieldProperty(String name, String value, FieldInfo info) {
            this.name = name;
            this.value = value;
            this.info = info;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getRendered() {
            List items;
            String source;
            String type;
            String description;
            StringBuilder rendered = new StringBuilder();
            String label = this.info == null ? this.name : this.info.label();
            rendered.append("<label>").append(label);
            String string = description = this.info == null ? "" : this.info.description();
            if (!"".equals(description)) {
                rendered.append(String.format("<span class=\"description\">%s</span>", description));
            }
            rendered.append("</label>");
            String string2 = type = this.info == null ? "" : this.info.type();
            if ("text area".equals(type)) {
                rendered.append(String.format("<textarea name=\"%s\" class=\"fieldInput\">%s</textarea>", this.name, this.value));
            } else if ("string".equals(type)) {
                rendered.append(String.format("<input type=\"text\" class=\"textInput fieldInput\" name=\"%s\" value=\"%s\" />", this.name, this.value));
            } else if ("selection".equals(type) && !(source = this.info.source()).equals("") && (items = Manager.getVocabularyManager().getItems(source)) != null) {
                rendered.append(String.format("<select class=\"fieldInput\" name=\"%s\">", this.name));
                boolean found = false;
                for (VocabularyItem item : items) {
                    String itemValue = item.getValue();
                    if (itemValue.equals(this.value)) {
                        rendered.append(String.format("<option selected=\"selected\" value=\"%s\">%s</option>", itemValue, item.getLabel()));
                        found = true;
                        continue;
                    }
                    rendered.append(String.format("<option value=\"%s\">%s</option>", itemValue, item.getLabel()));
                }
                if (!found) {
                    rendered.append(String.format("<option>Invalid option: %s</option>", this.value));
                }
                rendered.append("</select>");
            }
            if (this.info.required() && this.value.equals("")) {
                rendered.append("<span style=\"color: red\"> * </span>");
            }
            return rendered.toString();
        }
    }

    public static class PageInfo {
        final String name;
        final String link;
        final String className;

        public PageInfo(String name, String link, String className) {
            this.name = name;
            this.link = link;
            this.className = className;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }

        public String getLink() {
            return this.link;
        }
    }

    public static class ThemeInfo {
        final String name;
        final String link;
        final String className;

        public ThemeInfo(String name, String link, String className) {
            this.name = name;
            this.link = link;
            this.className = className;
        }

        public String getName() {
            return this.name;
        }

        public String getLink() {
            return this.link;
        }

        public String getClassName() {
            return this.className;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FragmentInfo {
        private final FragmentType fragmentType;
        private final List<ViewType> viewTypes = new ArrayList<ViewType>();

        public FragmentInfo(FragmentType fragmentType) {
            this.fragmentType = fragmentType;
        }

        public FragmentType getFragmentType() {
            return this.fragmentType;
        }

        public void addView(ViewType viewType) {
            this.viewTypes.add(viewType);
        }

        public List<ViewType> getViews() {
            return this.viewTypes;
        }

        public int size() {
            return this.viewTypes.size();
        }
    }
}

