/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.editor;

import java.util.Properties;
import org.nuxeo.theme.editor.previews.Preview;
import org.nuxeo.theme.html.Utils;
import org.nuxeo.theme.presets.PresetType;

public class PresetInfo {
    private static final String PREVIEW_PROPERTIES_RESOURCE = "/nxthemes/editor/styles/previews.properties";
    private final Properties previewProperties = new Properties();
    final PresetType preset;

    public PresetInfo(PresetType preset) {
        this.preset = preset;
    }

    public String getName() {
        return this.preset.getTypeName();
    }

    public String getPreview() {
        String category = this.preset.getCategory();
        String previewClassName = this.getPreviewProperties().getProperty(category);
        if (previewClassName == null) {
            return "";
        }
        Preview preview = null;
        try {
            preview = (Preview)Class.forName(previewClassName).newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (preview == null) {
            return "";
        }
        String content = this.preset.getName();
        return preview.render(this.preset.getValue(), content);
    }

    private Properties getPreviewProperties() {
        Utils.loadProperties((Properties)this.previewProperties, (String)PREVIEW_PROPERTIES_RESOURCE);
        return this.previewProperties;
    }
}

