/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.editor.views;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.jsf.filters.layouts.DefaultLayoutView;
import org.nuxeo.theme.rendering.RenderingInfo;

public class CellLayout
extends DefaultLayoutView {
    static final Pattern contentPattern = Pattern.compile("<.*?>(.*)</td>", 32);

    public String render(RenderingInfo info) {
        String markup = info.getMarkup();
        Matcher contentMatcher = contentPattern.matcher(markup);
        if (!contentMatcher.find()) {
            return markup;
        }
        Format layout = info.getFormat();
        StringBuilder style = new StringBuilder();
        String width = layout.getProperty("width");
        if (width != null) {
            style.append("width:").append(width).append(';');
        } else {
            width = "";
        }
        String textAlign = layout.getProperty("text-align");
        if (textAlign != null) {
            style.append("text-align:").append(textAlign).append(';');
        }
        String cellId = info.getElement().getUid().toString();
        StringBuilder html = new StringBuilder();
        html.append(String.format("<td class=\"nxthemesCellLayout nxthemesContainer\" style=\"%s\" id=\"%s\">", style.toString(), cellId));
        html.append("<form class=\"nxthemesSizer\" action=\"\" onsubmit=\"return false\">").append("<b class=\"left\"></b><b class=\"right\"></b>").append("<input class=\"nxthemesInput\" type=\"text\" size=\"5\"").append(" value=\"").append(width).append("\" name=\"width\" />").append("<input type=\"hidden\" name=\"id\" value=\"").append(layout.getUid().toString()).append("\" /></form>");
        html.append(contentMatcher.group(1));
        html.append("</td>");
        return html.toString();
    }
}

