/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.editor.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.rendering.StandaloneFilter;

public final class ElementUid
extends StandaloneFilter {
    static final Pattern firstTagPattern = Pattern.compile("<(.*?)>", 32);
    static final Pattern otherTagsPattern = Pattern.compile("<.*?>(.*)", 32);

    public RenderingInfo process(RenderingInfo info, boolean cache) {
        String markup = info.getMarkup();
        Matcher firstMatcher = firstTagPattern.matcher(markup);
        Matcher othersMatcher = otherTagsPattern.matcher(markup);
        if (!firstMatcher.find() || !othersMatcher.find()) {
            return info;
        }
        String inBrackets = firstMatcher.group(1);
        inBrackets = inBrackets.replaceAll(" id=\"(.*?)\"", "");
        String f = "";
        f = inBrackets.endsWith("/") ? String.format("<%s id=\"%s\" />%s", inBrackets.replaceAll("/$", "").trim(), info.getElement().getUid(), othersMatcher.group(1)) : String.format("<%s id=\"%s\">%s", inBrackets, info.getElement().getUid(), othersMatcher.group(1));
        info.setMarkup(f);
        return info;
    }
}

