/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.editor.filters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.CellElement;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.elements.ElementType;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.FormatType;
import org.nuxeo.theme.fragments.Fragment;
import org.nuxeo.theme.fragments.FragmentType;
import org.nuxeo.theme.jsf.Utils;
import org.nuxeo.theme.models.ModelType;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.rendering.StandaloneFilter;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.views.ViewType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONModel
extends StandaloneFilter {
    static final Pattern firstTagPattern = Pattern.compile("<(.*?)>", 32);
    static final Pattern otherTagsPattern = Pattern.compile("<.*?>(.*)", 32);
    static final String[] ALIGNMENTS = new String[]{"left", "center", "right"};

    public RenderingInfo process(RenderingInfo info, boolean cache) {
        Element element = info.getElement();
        String typeName = element.getElementType().getTypeName();
        String markup = info.getMarkup();
        String viewMode = info.getViewMode();
        if (viewMode != null && viewMode.startsWith("area-styles")) {
            return info;
        }
        Matcher firstMatcher = firstTagPattern.matcher(markup);
        Matcher othersMatcher = otherTagsPattern.matcher(markup);
        if (!firstMatcher.find() || !othersMatcher.find()) {
            return info;
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        HashMap<String, Object> model_data = new HashMap<String, Object>();
        model_data.put("title", typeName);
        model_data.put("editable", false);
        model_data.put("duplicable", false);
        model_data.put("alignable", false);
        model_data.put("splittable", false);
        model_data.put("copyable", false);
        model_data.put("deletable", false);
        model_data.put("pastable", false);
        model_data.put("has widget", false);
        model_data.put("has style", false);
        model_data.put("has padding", false);
        if (element instanceof Fragment) {
            FragmentType fragmentType = ((Fragment)element).getFragmentType();
            model_data.put("title", fragmentType.getTypeName());
            model_data.put("editable", true);
            model_data.put("duplicable", true);
            model_data.put("copyable", true);
            model_data.put("deletable", true);
            model_data.put("pastable", true);
            model_data.put("widgets", this.getWidgetsFor(element));
            model_data.put("has widget", true);
            model_data.put("has style", true);
        } else if (element instanceof CellElement) {
            if (viewMode.equals("layout")) {
                model_data.put("splittable", true);
                model_data.put("deletable", true);
            }
            model_data.put("pastable", true);
            model_data.put("alignable", true);
            model_data.put("alignments", this.getAlignments());
            model_data.put("has padding", true);
        }
        model.put("id", String.format("%s-%s", info.getUid(), viewMode));
        model.put("data", model_data);
        StringBuilder s = new StringBuilder();
        s.append("<");
        s.append(firstMatcher.group(1));
        s.append(">");
        s.append("<ins class=\"model\">");
        s.append("<f:verbatim xmlns:f=\"http://java.sun.com/jsf/core\">");
        s.append(Utils.toJson(model));
        s.append("</f:verbatim></ins>");
        s.append(othersMatcher.group(1));
        info.setMarkup(s.toString());
        return info;
    }

    private List<Map<String, Object>> getWidgetsFor(Element element) {
        ArrayList<Map<String, Object>> widgets = new ArrayList<Map<String, Object>>();
        FragmentType fragmentType = ((Fragment)element).getFragmentType();
        ModelType modelType = fragmentType.getModelType();
        FormatType widgetType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "widget");
        Format widget = ElementFormatter.getFormatByType((Object)element, (FormatType)widgetType);
        if (widget == null) {
            return widgets;
        }
        String thisViewName = widget.getName();
        for (Type v : Manager.getTypeRegistry().getTypes(TypeFamily.VIEW)) {
            ViewType viewType = (ViewType)v;
            ElementType elementType = viewType.getElementType();
            if (elementType != null && !elementType.getTypeName().equals("fragment") || !viewType.getFormatType().getTypeName().equals("widget") || modelType != viewType.getModelType()) continue;
            HashMap<String, Object> widgetInfo = new HashMap<String, Object>();
            String viewName = viewType.getViewName();
            widgetInfo.put("choice", viewName);
            widgetInfo.put("label", viewName);
            if (thisViewName.equals(viewName)) {
                widgetInfo.put("selected", true);
            }
            widgets.add(widgetInfo);
        }
        return widgets;
    }

    private List<Map<String, Object>> getAlignments() {
        ArrayList<Map<String, Object>> alignments = new ArrayList<Map<String, Object>>();
        for (String position : ALIGNMENTS) {
            HashMap<String, String> alignmentInfo = new HashMap<String, String>();
            alignmentInfo.put("choice", position);
            alignmentInfo.put("label", position);
            alignmentInfo.put("icon", String.format("/nuxeo/nxthemes-jsf-editor/icons/align-%s-16.png", position));
            alignments.add(alignmentInfo);
        }
        return alignments;
    }
}

