/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.editor.actions;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ejb.Remove;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.SerializedConcurrentAccess;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.CellElement;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementFactory;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.elements.PageElement;
import org.nuxeo.theme.elements.SectionElement;
import org.nuxeo.theme.elements.ThemeElement;
import org.nuxeo.theme.events.EventContext;
import org.nuxeo.theme.events.EventManager;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.FormatFactory;
import org.nuxeo.theme.formats.FormatType;
import org.nuxeo.theme.formats.layouts.Layout;
import org.nuxeo.theme.formats.styles.Style;
import org.nuxeo.theme.formats.widgets.Widget;
import org.nuxeo.theme.fragments.Fragment;
import org.nuxeo.theme.fragments.FragmentFactory;
import org.nuxeo.theme.jsf.Utils;
import org.nuxeo.theme.jsf.editor.actions.EditorActionLocal;
import org.nuxeo.theme.jsf.editor.managers.UiManagerLocal;
import org.nuxeo.theme.jsf.editor.states.UiStatesLocal;
import org.nuxeo.theme.nodes.Node;
import org.nuxeo.theme.perspectives.PerspectiveManager;
import org.nuxeo.theme.presets.PresetType;
import org.nuxeo.theme.properties.FieldIO;
import org.nuxeo.theme.themes.ThemeIOException;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.uids.UidManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Name(value="nxthemesEditorAction")
@Scope(value=ScopeType.SESSION)
@SerializedConcurrentAccess
public class EditorAction
implements EditorActionLocal {
    private static final Log log = LogFactory.getLog(EditorAction.class);
    private static final UidManager uidManager = Manager.getUidManager();
    private static final EventManager eventManager = Manager.getEventManager();
    private static final ThemeManager themeManager = Manager.getThemeManager();
    private static final String THEME_MODIFIED_EVENT = "theme modified";
    private static final String STYLES_MODIFIED_EVENT = "styles modified";
    @In(value="nxthemesUiStates", create=true)
    public UiStatesLocal uiStates;
    @In(value="nxthemesUiManager", create=true)
    public UiManagerLocal uiManager;

    @Override
    public String addTheme(String name) {
        if (themeManager.getThemeByName(name) != null) {
            log.debug((Object)("Theme already exists: " + name));
            return "";
        }
        ThemeElement theme = (ThemeElement)ElementFactory.create((String)"theme");
        theme.setName(name);
        Format themeWidget = FormatFactory.create((String)"widget");
        themeWidget.setName("theme view");
        themeManager.registerFormat(themeWidget);
        ElementFormatter.setFormat((Object)theme, (Format)themeWidget);
        PageElement page = (PageElement)ElementFactory.create((String)"page");
        page.setName("default");
        Format pageWidget = FormatFactory.create((String)"widget");
        themeManager.registerFormat(pageWidget);
        pageWidget.setName("page frame");
        Format pageLayout = FormatFactory.create((String)"layout");
        themeManager.registerFormat(pageLayout);
        Format pageStyle = FormatFactory.create((String)"style");
        themeManager.registerFormat(pageStyle);
        ElementFormatter.setFormat((Object)page, (Format)pageWidget);
        ElementFormatter.setFormat((Object)page, (Format)pageStyle);
        ElementFormatter.setFormat((Object)page, (Format)pageLayout);
        theme.addChild((Node)page);
        themeManager.registerTheme(theme);
        log.debug((Object)("Added theme: " + name));
        return String.format("%s/%s", name, "default");
    }

    @Override
    public String addPage(String path) {
        if (!path.contains("/")) {
            log.debug((Object)("Page paths must contain '/': " + path));
            return "";
        }
        if (themeManager.getPageByPath(path) != null) {
            log.debug((Object)("Page already exists: " + path));
            return "";
        }
        String themeName = path.split("/")[0];
        ThemeElement theme = themeManager.getThemeByName(themeName);
        PageElement page = (PageElement)ElementFactory.create((String)"page");
        String pageName = path.split("/")[1];
        page.setName(pageName);
        Format pageWidget = FormatFactory.create((String)"widget");
        pageWidget.setName("page frame");
        themeManager.registerFormat(pageWidget);
        Format pageLayout = FormatFactory.create((String)"layout");
        themeManager.registerFormat(pageLayout);
        Format pageStyle = FormatFactory.create((String)"style");
        themeManager.registerFormat(pageStyle);
        ElementFormatter.setFormat((Object)page, (Format)pageWidget);
        ElementFormatter.setFormat((Object)page, (Format)pageStyle);
        ElementFormatter.setFormat((Object)page, (Format)pageLayout);
        themeManager.registerPage(theme, page);
        return path;
    }

    @Override
    public String moveElement(String srcId, String destId, Integer order) {
        Element srcElement = this.getElementById(srcId);
        Element destElement = this.getElementById(destId);
        srcElement.moveTo((Node)destElement, order);
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext((Object)srcElement, (Object)destElement));
        log.debug((Object)("Moved element: " + srcId + " to: " + destId));
        return "";
    }

    @Override
    public String selectElement(String id) {
        Element element = this.getElementById(id);
        if (element != null) {
            this.uiStates.setSelectedElement(element);
            this.uiStates.setCurrentStyleSelector(null);
            this.uiStates.setStyleCategory(null);
            this.uiStates.setCurrentStyleLayer(null);
        }
        return id;
    }

    @Override
    public List<String> copyElements(List<String> ids) {
        this.clearClipboard();
        for (String id : ids) {
            this.addElementToClipboard(id);
        }
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext(null, null));
        log.debug((Object)("Copied the elements: " + ids + " to the clipboard."));
        return null;
    }

    @Override
    public String duplicateElement(String id) {
        Element element = this.getElementById(id);
        Element duplicate = themeManager.duplicateElement(element, false);
        element.getParent().addChild((Node)duplicate);
        duplicate.moveTo(element.getParent(), Integer.valueOf(element.getOrder() + 1));
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext(null, (Object)element));
        log.debug((Object)("Duplicated the element: " + element));
        return duplicate.getUid().toString();
    }

    @Override
    public List<String> pasteElements(String destId) {
        Element destElement = this.getElementById(destId);
        if (destElement.isLeaf()) {
            destElement = (Element)destElement.getParent();
        }
        List<String> ids = this.uiStates.getClipboardElements();
        for (String id : ids) {
            Element element = this.getElementById(id);
            if (element == null) {
                log.debug((Object)("Element to paste not found: " + id));
                continue;
            }
            boolean duplicateFormats = true;
            if (ThemeManager.belongToSameTheme((Element)element, (Element)destElement)) {
                duplicateFormats = false;
            }
            destElement.addChild((Node)themeManager.duplicateElement(element, duplicateFormats));
        }
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext(null, (Object)destElement));
        log.debug((Object)("Pasted the elements: " + ids + " from the clipboard."));
        return null;
    }

    @Override
    public String deleteElement(String id) {
        Element element = this.getElementById(id);
        Element parent = (Element)element.getParent();
        if (element instanceof ThemeElement) {
            themeManager.destroyElement((Element)((ThemeElement)element));
        } else if (element instanceof PageElement) {
            themeManager.destroyElement((Element)((PageElement)element));
        } else if (element instanceof CellElement) {
            if (element.hasSiblings()) {
                String width2;
                String newWidth;
                Format layout2;
                String width1;
                FormatType layoutType;
                Format layout1;
                Element sibling = (Element)element.getNextNode();
                if (sibling == null) {
                    sibling = (Element)element.getPreviousNode();
                }
                if ((layout1 = ElementFormatter.getFormatByType((Object)element, (FormatType)(layoutType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "layout")))) != null && (width1 = layout1.getProperty("width")) != null && (layout2 = ElementFormatter.getFormatByType((Object)sibling, (FormatType)layoutType)) != null && (newWidth = Utils.addWebLengths((String)width1, (String)(width2 = layout2.getProperty("width")))) != null) {
                    layout2.setProperty("width", newWidth);
                }
                themeManager.destroyElement(element);
            } else {
                themeManager.destroyElement(parent);
            }
        } else if (element instanceof Fragment) {
            themeManager.destroyElement(element);
        }
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext(null, null));
        log.debug((Object)("Deleted element: " + id));
        return id;
    }

    @Override
    public String insertFragment(String typeName, String destId, Integer order) {
        if (destId == null) {
            return "";
        }
        Element destElement = this.getElementById(destId);
        String fragmentTypeName = typeName.split("/")[0];
        Fragment fragment = FragmentFactory.create((String)fragmentTypeName);
        Format widget = FormatFactory.create((String)"widget");
        String viewTypeName = typeName.split("/")[1];
        widget.setName(viewTypeName);
        themeManager.registerFormat(widget);
        ElementFormatter.setFormat((Object)fragment, (Format)widget);
        destElement.addChild((Node)fragment);
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext((Object)fragment, (Object)destElement));
        return "";
    }

    @Override
    public String expireThemes() {
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext(null, null));
        return "";
    }

    @Override
    public void addElementToClipboard(String id) {
        this.uiStates.getClipboardElements().add(id);
    }

    @Override
    public void clearClipboard() {
        this.uiStates.getClipboardElements().clear();
    }

    @Override
    public void updateElementWidget(String id, String viewName) {
        FormatType widgetType;
        Element element = this.getElementById(id);
        Format widget = ElementFormatter.getFormatByType((Object)element, (FormatType)(widgetType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "widget")));
        if (widget == null) {
            widget = FormatFactory.create((String)"widget");
            themeManager.registerFormat(widget);
        }
        widget.setName(viewName);
        ElementFormatter.setFormat((Object)element, (Format)widget);
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext((Object)element, null));
    }

    @Override
    public void updateElementStyle(String id, String viewName, String path, Map propertyMap) {
        Element element = this.getElementById(id);
        Properties properties = new Properties();
        for (Object key : propertyMap.keySet()) {
            properties.put(key, propertyMap.get(key));
        }
        FormatType styleType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "style");
        Style style = (Style)ElementFormatter.getFormatByType((Object)element, (FormatType)styleType);
        Style currentStyleLayer = this.uiStates.getCurrentStyleLayer();
        if (currentStyleLayer != null) {
            style = currentStyleLayer;
        }
        if (style.getName() != null || "".equals(viewName)) {
            viewName = "*";
        }
        style.setPropertiesFor(viewName, path, properties);
        eventManager.notify(STYLES_MODIFIED_EVENT, new EventContext((Object)element, null));
    }

    @Override
    public void updateElementStyleCss(String id, String viewName, String cssSource) {
        Element element = this.getElementById(id);
        FormatType styleType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "style");
        Style style = (Style)ElementFormatter.getFormatByType((Object)element, (FormatType)styleType);
        Style currentStyleLayer = this.uiStates.getCurrentStyleLayer();
        if (currentStyleLayer != null) {
            style = currentStyleLayer;
        }
        if (style.getName() != null || "".equals(viewName)) {
            viewName = "*";
        }
        Utils.loadCss((Style)style, (String)cssSource, (String)viewName);
        eventManager.notify(STYLES_MODIFIED_EVENT, new EventContext((Object)element, null));
    }

    @Override
    public void setElementVisibility(String id, List<String> perspectives, boolean alwaysVisible) {
        Element element = this.getElementById(id);
        PerspectiveManager perspectiveManager = Manager.getPerspectiveManager();
        if (alwaysVisible) {
            perspectiveManager.setAlwaysVisible(element);
        } else if (perspectives.isEmpty()) {
            perspectiveManager.setVisibleInAllPerspectives(element);
        } else {
            perspectiveManager.setVisibleInPerspectives(element, perspectives);
        }
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext((Object)element, null));
    }

    @Override
    public void updateElementProperties(String id, Map propertyMap) {
        Element element = this.getElementById(id);
        Properties properties = new Properties();
        for (Object key : propertyMap.keySet()) {
            properties.put(key, propertyMap.get(key));
        }
        try {
            FieldIO.updateFieldsFromProperties((Object)element, (Properties)properties);
        }
        catch (Exception e) {
            log.warn((Object)("Could not update properties of element: " + id));
            return;
        }
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext((Object)element, null));
    }

    @Override
    public void updateElementLayout(Map propertyMap) {
        Element element = this.uiStates.getSelectedElement();
        if (element != null) {
            Layout layout = (Layout)ElementFormatter.getFormatFor((Element)element, (String)"layout");
            if (layout == null) {
                layout = (Layout)FormatFactory.create((String)"layout");
                themeManager.registerFormat((Format)layout);
                ElementFormatter.setFormat((Object)element, (Format)layout);
            }
            for (Object key : propertyMap.keySet()) {
                layout.setProperty((String)key, (String)propertyMap.get(key));
            }
            eventManager.notify(THEME_MODIFIED_EVENT, new EventContext((Object)element, null));
        }
    }

    @Override
    public void setSize(String id, String width) {
        Format layout = this.getFormatById(id);
        layout.setProperty("width", width);
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext((Object)layout, null));
    }

    @Override
    public void splitElement(String id) {
        String halfWidth;
        Element element = this.getElementById(id);
        if (!element.getElementType().getTypeName().equals("cell")) {
            return;
        }
        Element newCell = ElementFactory.create((String)"cell");
        Format cellWidget = FormatFactory.create((String)"widget");
        cellWidget.setName("cell frame");
        themeManager.registerFormat(cellWidget);
        Format cellLayout = FormatFactory.create((String)"layout");
        themeManager.registerFormat(cellLayout);
        FormatType layoutType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "layout");
        Format layout = ElementFormatter.getFormatByType((Object)element, (FormatType)layoutType);
        String width = layout.getProperty("width");
        if (width != null && (halfWidth = Utils.divideWebLength((String)width, (int)2)) != null) {
            cellLayout.setProperty("width", halfWidth);
            layout.setProperty("width", Utils.substractWebLengths((String)width, (String)halfWidth));
        }
        Format cellStyle = FormatFactory.create((String)"style");
        themeManager.registerFormat(cellStyle);
        ElementFormatter.setFormat((Object)newCell, (Format)cellWidget);
        ElementFormatter.setFormat((Object)newCell, (Format)cellLayout);
        ElementFormatter.setFormat((Object)newCell, (Format)cellStyle);
        newCell.insertAfter((Node)element);
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext((Object)element, null));
    }

    @Override
    public void insertSectionAfter(String id) {
        Element element = this.getElementById(id);
        Element newSection = ElementFactory.create((String)"section");
        Element newCell = ElementFactory.create((String)"cell");
        Format sectionWidget = FormatFactory.create((String)"widget");
        sectionWidget.setName("section frame");
        themeManager.registerFormat(sectionWidget);
        Format sectionLayout = FormatFactory.create((String)"layout");
        sectionLayout.setProperty("width", "100%");
        themeManager.registerFormat(sectionLayout);
        Format sectionStyle = FormatFactory.create((String)"style");
        themeManager.registerFormat(sectionStyle);
        ElementFormatter.setFormat((Object)newSection, (Format)sectionWidget);
        ElementFormatter.setFormat((Object)newSection, (Format)sectionLayout);
        ElementFormatter.setFormat((Object)newSection, (Format)sectionStyle);
        Format cellWidget = FormatFactory.create((String)"widget");
        cellWidget.setName("cell frame");
        themeManager.registerFormat(cellWidget);
        Format cellLayout = FormatFactory.create((String)"layout");
        themeManager.registerFormat(cellLayout);
        cellLayout.setProperty("width", "100%");
        Format cellStyle = FormatFactory.create((String)"style");
        themeManager.registerFormat(cellStyle);
        ElementFormatter.setFormat((Object)newCell, (Format)cellWidget);
        ElementFormatter.setFormat((Object)newCell, (Format)cellLayout);
        ElementFormatter.setFormat((Object)newCell, (Format)cellStyle);
        newSection.addChild((Node)newCell);
        String elementTypeName = element.getElementType().getTypeName();
        if (elementTypeName.equals("section")) {
            newSection.insertAfter((Node)element);
        } else if (elementTypeName.equals("page")) {
            element.addChild((Node)newSection);
        }
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext((Object)newSection, null));
    }

    @Override
    public void alignElement(String id, String position) {
        Element element = this.getElementById(id);
        Layout layout = (Layout)ElementFormatter.getFormatFor((Element)element, (String)"layout");
        if (layout == null) {
            layout = (Layout)FormatFactory.create((String)"layout");
            themeManager.registerFormat((Format)layout);
            ElementFormatter.setFormat((Object)element, (Format)layout);
        }
        if (element instanceof SectionElement) {
            if (position.equals("left")) {
                layout.setProperty("margin-left", "0");
                layout.setProperty("margin-right", "auto");
            } else if (position.equals("center")) {
                layout.setProperty("margin-left", "auto");
                layout.setProperty("margin-right", "auto");
            } else if (position.equals("right")) {
                layout.setProperty("margin-left", "auto");
                layout.setProperty("margin-right", "0");
            }
        } else if (position.equals("left")) {
            layout.setProperty("text-align", "left");
        } else if (position.equals("center")) {
            layout.setProperty("text-align", "center");
        } else if (position.equals("right")) {
            layout.setProperty("text-align", "right");
        }
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext((Object)element, null));
    }

    @Override
    public void setCurrentStyleSelector(String currentStyleSelector) {
        this.uiStates.setCurrentStyleSelector(currentStyleSelector);
    }

    @Override
    public void setStyleEditMode(String mode) {
        this.uiStates.setStyleEditMode(mode);
    }

    @Override
    public void setStylePropertyCategory(String category) {
        this.uiStates.setStylePropertyCategory(category);
    }

    @Override
    public void setStyleCategory(String category) {
        this.uiStates.setStyleCategory(category);
    }

    @Override
    public void setPresetGroup(String group) {
        this.uiStates.setPresetGroup(group);
    }

    @Override
    public void assignStyleProperty(String id, String property, String value) {
        Widget widget;
        Element element = this.getElementById(id);
        if (element == null) {
            return;
        }
        Style style = (Style)ElementFormatter.getFormatFor((Element)element, (String)"style");
        if (style == null) {
            style = (Style)FormatFactory.create((String)"style");
            themeManager.registerFormat((Format)style);
            ElementFormatter.setFormat((Object)element, (Format)style);
        }
        if ((widget = (Widget)ElementFormatter.getFormatFor((Element)element, (String)"widget")) == null) {
            log.error((Object)("Element " + element.computeXPath() + " has no widget."));
            return;
        }
        String viewName = widget.getName();
        Properties properties = style.getPropertiesFor(viewName, "");
        if (properties == null) {
            properties = new Properties();
        }
        if (value == null) {
            properties.remove(property);
        } else {
            properties.setProperty(property, value);
        }
        style.setPropertiesFor(viewName, "", properties);
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext((Object)element, null));
        eventManager.notify(STYLES_MODIFIED_EVENT, new EventContext((Object)style, null));
    }

    @Override
    public void createStyle() {
        Element element = this.uiStates.getSelectedElement();
        if (element == null) {
            return;
        }
        Format style = FormatFactory.create((String)"style");
        themeManager.registerFormat(style);
        ElementFormatter.setFormat((Object)element, (Format)style);
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext((Object)element, null));
    }

    @Override
    public void setCurrentStyleLayer(Integer uid) {
        Style layer = (Style)uidManager.getObjectByUid(uid);
        if (layer != null) {
            this.uiStates.setCurrentStyleLayer(layer);
        }
    }

    @Override
    public boolean repairTheme(String themeName) {
        ThemeElement theme = themeManager.getThemeByName(themeName);
        if (theme == null) {
            log.error((Object)("Theme not found: " + themeName));
            return false;
        }
        ThemeManager.repairTheme((ThemeElement)theme);
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext((Object)theme, null));
        eventManager.notify(STYLES_MODIFIED_EVENT, new EventContext((Object)theme, null));
        log.debug((Object)("Theme repaired: " + themeName));
        return true;
    }

    @Override
    public boolean loadTheme(String src) {
        try {
            themeManager.loadTheme(src);
        }
        catch (ThemeIOException e) {
            log.error((Object)e);
            return false;
        }
        eventManager.notify(THEME_MODIFIED_EVENT, new EventContext(null, null));
        eventManager.notify(STYLES_MODIFIED_EVENT, new EventContext(null, null));
        log.debug((Object)("Theme loaded: " + src));
        return true;
    }

    @Override
    public boolean saveTheme(String src) {
        try {
            ThemeManager.saveTheme((String)src);
        }
        catch (ThemeIOException e) {
            log.error((Object)e);
            return false;
        }
        log.debug((Object)("Theme saved: " + src));
        return true;
    }

    @Override
    public String renderCssPreview(String cssPreviewId) {
        ThemeManager themeManager = Manager.getThemeManager();
        Style style = this.uiManager.getStyleOfSelectedElement();
        Style currentStyleLayer = this.uiStates.getCurrentStyleLayer();
        if (currentStyleLayer != null) {
            style = currentStyleLayer;
        }
        if (style == null) {
            return "";
        }
        StringBuilder css = new StringBuilder();
        ArrayList<Style> styles = new ArrayList<Style>();
        for (Format ancestor : themeManager.listAncestorFormatsOf((Format)style)) {
            styles.add(0, (Style)ancestor);
        }
        styles.add(style);
        String currentViewName = this.uiManager.getCurrentViewName();
        for (Style s : styles) {
            String viewName = currentViewName;
            if (s.getName() != null) {
                viewName = "*";
            }
            for (String path : s.getPathsForView(viewName)) {
                css.append('#').append(cssPreviewId);
                css.append(' ').append(path).append(" {");
                Properties styleProperties = s.getPropertiesFor(viewName, path);
                Enumeration<?> propertyNames = Utils.getCssProperties().propertyNames();
                while (propertyNames.hasMoreElements()) {
                    String propertyName = (String)propertyNames.nextElement();
                    String value = styleProperties.getProperty(propertyName);
                    if (value == null) continue;
                    css.append(propertyName);
                    css.append(':');
                    PresetType preset = ThemeManager.resolvePreset((String)value);
                    if (preset != null) {
                        value = preset.getValue();
                    }
                    css.append(value);
                    css.append(';');
                }
                css.append('}');
            }
        }
        return css.toString();
    }

    private Element getElementById(String id) {
        return (Element)uidManager.getObjectByUid(Integer.valueOf(id));
    }

    private Format getFormatById(String id) {
        return (Format)uidManager.getObjectByUid(Integer.valueOf(id));
    }

    @Override
    @Remove
    public void destroy() {
        log.debug((Object)"Removed SEAM component: nxthemesActions");
    }
}

