/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf.editor.filters;

import java.net.URL;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.ElementFormatter;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.FormatType;
import org.nuxeo.theme.fragments.Fragment;
import org.nuxeo.theme.perspectives.PerspectiveType;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.rendering.StandaloneFilter;
import org.nuxeo.theme.themes.ThemeManager;
import org.nuxeo.theme.types.TypeFamily;

public class FragmentVisibility
extends StandaloneFilter {
    private static final Log log = LogFactory.getLog(FragmentVisibility.class);

    public RenderingInfo process(RenderingInfo info, boolean cache) {
        Element element = info.getElement();
        if (element instanceof Fragment) {
            String viewMode = info.getViewMode();
            if (viewMode != null && viewMode.startsWith("area-styles")) {
                return null;
            }
            Fragment fragment = (Fragment)element;
            Manager.getThemeManager();
            PerspectiveType perspective = ThemeManager.getPerspectiveByUrl((URL)info.getThemeUrl());
            FormatType widgetType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, "widget");
            Format format = ElementFormatter.getFormatByType((Object)fragment, (FormatType)widgetType);
            if (format == null) {
                return info;
            }
            if (viewMode.equals("fragment") || viewMode.equals("layout")) {
                StringBuilder content = new StringBuilder();
                content.append("<div class=\"nxthemesFragment\">");
                content.append(String.format("%s / %s", fragment.getFragmentType().getTypeName(), format.getName()));
                content.append("</div>");
                info.setMarkup(content.toString());
                return info;
            }
            if (perspective != null && !fragment.isVisibleInPerspective(perspective)) {
                StringBuilder content = new StringBuilder();
                content.append("<div class=\"nxthemesFragment\">");
                content.append(String.format("%s / %s", fragment.getFragmentType().getTypeName(), format.getName()));
                content.append(" (only visible in: ");
                Iterator it = fragment.getVisibilityPerspectives().iterator();
                while (it.hasNext()) {
                    PerspectiveType p = (PerspectiveType)it.next();
                    content.append(p.getTitle());
                    if (!it.hasNext()) continue;
                    content.append(", ");
                }
                content.append(")</div>");
                info.setMarkup(content.toString());
            }
        } else {
            log.warn((Object)"The 'fragment visibility' filter can only be applied to fragments.");
        }
        return info;
    }
}

